/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootCategory;

public class LogManager {
    public static final String DEFAULT_CONFIGURATION_FILE = "log4j.properties";
    public static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    public static final String CONFIGURATOR_CLASS_KEY = "log4j.configuratorClass";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "log4j.defaultInitOverride";
    private static Object guard = null;
    private static RepositorySelector repositorySelector;

    static {
        Hierarchy h = new Hierarchy(new RootCategory(Level.DEBUG));
        repositorySelector = new DefaultRepositorySelector(h);
        String override = OptionConverter.getSystemProperty(DEFAULT_INIT_OVERRIDE_KEY, null);
        if (override == null || "false".equalsIgnoreCase(override)) {
            String resource = OptionConverter.getSystemProperty(DEFAULT_CONFIGURATION_KEY, DEFAULT_CONFIGURATION_FILE);
            String configuratorClassName = OptionConverter.getSystemProperty(CONFIGURATOR_CLASS_KEY, null);
            URL url = null;
            try {
                url = new URL(resource);
            }
            catch (MalformedURLException malformedURLException) {
                url = Loader.getResource(resource);
            }
            if (url != null) {
                LogLog.debug("Using URL [" + url + "] for automatic log4j configuration.");
                OptionConverter.selectAndConfigure(url, configuratorClassName, LogManager.getLoggerRepository());
            } else {
                LogLog.debug("Could not find resource: [" + resource + "].");
            }
        }
    }

    public static void setRepositorySelector(RepositorySelector selector, Object guard) throws IllegalArgumentException {
        if (LogManager.guard != null && LogManager.guard != guard) {
            throw new IllegalArgumentException("Attempted to reset the LoggerFactory without possessing the guard.");
        }
        if (selector == null) {
            throw new IllegalArgumentException("RepositorySelector must be non-null.");
        }
        LogManager.guard = guard;
        repositorySelector = selector;
    }

    public static LoggerRepository getLoggerRepository() {
        return repositorySelector.getLoggerRepository();
    }

    public static Logger getRootLogger() {
        return repositorySelector.getLoggerRepository().getRootLogger();
    }

    public static Logger getLogger(String name) {
        return repositorySelector.getLoggerRepository().getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return repositorySelector.getLoggerRepository().getLogger(clazz.getName());
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return repositorySelector.getLoggerRepository().getLogger(name, factory);
    }

    public static Logger exists(String name) {
        return repositorySelector.getLoggerRepository().exists(name);
    }

    public static Enumeration getCurrentLoggers() {
        return repositorySelector.getLoggerRepository().getCurrentLoggers();
    }

    public static void shutdown() {
        repositorySelector.getLoggerRepository().shutdown();
    }

    public static void resetConfiguration() {
        repositorySelector.getLoggerRepository().resetConfiguration();
    }
}

