/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.performance;

import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.SimpleLayout;

public class NotLogging {
    static int runLength;
    static final int INITIAL_HASH_SIZE = 101;
    static String SHORT_MSG;
    static Category SHORT_CAT;
    static Category MEDIUM_CAT;
    static Category LONG_CAT;
    static Category INEXISTENT_SHORT_CAT;
    static Category INEXISTENT_MEDIUM_CAT;
    static Category INEXISTENT_LONG_CAT;
    static Category[] CAT_ARRAY;

    static {
        SHORT_MSG = "Hello World";
        SHORT_CAT = Category.getInstance("A0123456789");
        MEDIUM_CAT = Category.getInstance("A0123456789.B0123456789");
        LONG_CAT = Category.getInstance("A0123456789.B0123456789.C0123456789");
        INEXISTENT_SHORT_CAT = Category.getInstance("I0123456789");
        INEXISTENT_MEDIUM_CAT = Category.getInstance("I0123456789.B0123456789");
        INEXISTENT_LONG_CAT = Category.getInstance("I0123456789.B0123456789.C0123456789");
        CAT_ARRAY = new Category[]{SHORT_CAT, MEDIUM_CAT, LONG_CAT, INEXISTENT_SHORT_CAT, INEXISTENT_MEDIUM_CAT, INEXISTENT_LONG_CAT};
    }

    static void Usage() {
        System.err.println("Usage: java org.apache.log4j.test.NotLogging true|false runLength\ntrue indicates shipped code, false indicates code in development  where runLength is an int representing the run length of loops\nWe suggest that runLength be at least 100'000.");
        System.exit(1);
    }

    public static void main(String[] argv) {
        double delta;
        if (argv.length != 2) {
            NotLogging.Usage();
        }
        NotLogging.ProgramInit(argv);
        System.out.println();
        int i = 0;
        while (i < CAT_ARRAY.length) {
            delta = NotLogging.SimpleMessage(CAT_ARRAY[i], SHORT_MSG, runLength);
            System.out.println("Simple argument,          " + delta + " micros. Cat: " + CAT_ARRAY[i].getName());
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < CAT_ARRAY.length) {
            delta = NotLogging.FullyOptimizedComplexMessage(CAT_ARRAY[i], runLength);
            System.out.println("Fully optimized complex,  " + delta + " micros. Cat: " + CAT_ARRAY[i].getName());
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < CAT_ARRAY.length) {
            delta = NotLogging.ComplexMessage(CAT_ARRAY[i], runLength);
            System.out.println("Complex message argument, " + delta + " micros. Cat: " + CAT_ARRAY[i].getName());
            ++i;
        }
    }

    static void ProgramInit(String[] args) {
        try {
            runLength = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.err.println(e);
            NotLogging.Usage();
        }
        new ConsoleAppender(new SimpleLayout());
        if (!"false".equals(args[0])) {
            if ("true".equals(args[0])) {
                System.out.println("Flagging as shipped code.");
                LogManager.getLoggerRepository().setThreshold(Level.WARN);
            } else {
                NotLogging.Usage();
            }
        }
        SHORT_CAT.setLevel(Level.INFO);
        Category.getRoot().setLevel(Level.INFO);
    }

    static double SimpleMessage(Category category, String msg, long runLength) {
        long before = System.currentTimeMillis();
        int i = 0;
        while ((long)i < runLength) {
            category.debug(msg);
            ++i;
        }
        return (double)(System.currentTimeMillis() - before) * 1000.0 / (double)runLength;
    }

    static double FullyOptimizedComplexMessage(Category category, long runLength) {
        long before = System.currentTimeMillis();
        int i = 0;
        while ((long)i < runLength) {
            if (category.isDebugEnabled()) {
                category.debug("Message" + i + " bottles of beer standing on the wall.");
            }
            ++i;
        }
        return (double)(System.currentTimeMillis() - before) * 1000.0 / (double)runLength;
    }

    static double ComplexMessage(Category category, long runLength) {
        long before = System.currentTimeMillis();
        int i = 0;
        while ((long)i < runLength) {
            category.debug("Message" + i + " bottles of beer standing on the wall.");
            ++i;
        }
        return (double)(System.currentTimeMillis() - before) * 1000.0 / (double)runLength;
    }
}

