/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.command;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DDocument;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class DCommandFactory {
    private DDocument document;

    public DCommandFactory(DDocument document) {
        this.document = document;
    }

    public Command createAddElementCommand(DElement element) {
        return new AddElementCommand(element);
    }

    public Command createRemoveElementCommand(DElement element) {
        return new RemoveElementCommand(element);
    }

    public Command createSetDefaultConnectionTypeCommand(int type) {
        return new SetDefaultConnectionTypeCommand(type);
    }

    public Command createSetDefaultNodeTypeCommand(int type) {
        return new SetDefaultNodeTypeCommand(type);
    }

    public Command createSetSizeCommand(DNode node, Dimension size) {
        return new SetSizeCommand(node, size);
    }

    public Command createSetLocationCommand(DNode connection, Point location) {
        return new SetLocationCommand(connection, location);
    }

    public Command createSetBoundsCommand(DNode connection, Rectangle bounds) {
        return new SetBoundsCommand(connection, bounds);
    }

    public Command createSetNodeTypeCommand(DNode node, int type) {
        return new SetNodeTypeCommand(node, type);
    }

    public Command createSetConnectionTypeCommand(DConnection connection, int type) {
        return new SetConnectionTypeCommand(connection, type);
    }

    public Command createSetSourceConnectionConstraintCommand(DConnection connection, Object constraint) {
        return new SetSourceConnectionConstraintCommand(connection, constraint);
    }

    public Command createSetTargetConnectionConstraintCommand(DConnection connection, Object constraint) {
        return new SetTargetConnectionConstraintCommand(connection, constraint);
    }

    public Command createAddBendpointCommand(DConnection connection, DRelativePoint bendpoint, int index) {
        return new AddBendpointCommand(connection, bendpoint, index);
    }

    public Command createRemoveBendpointCommand(DConnection connection, int index) {
        return new RemoveBendpointCommand(connection, index);
    }

    public Command createMoveBendpointCommand(DConnection connection, int index, DRelativePoint point) {
        return new MoveBendpointCommand(connection, index, point);
    }

    public Command createReconnectConnectionCommand(DConnection connection, DNode source, DNode target) {
        return new ReconnectCommand(connection, source, target);
    }

    public Command createSetLocationCommand(DLabel label, DRelativePoint location) {
        return new SetLabelLocationCommand(label, location);
    }

    private class AddElementCommand
    extends Command {
        private DElement element;

        AddElementCommand(DElement element) {
            this.element = element;
        }

        public void execute() {
            DCommandFactory.this.document.addElement(this.element);
        }

        public void undo() {
            DCommandFactory.this.document.removeElement(this.element);
        }
    }

    private class RemoveElementCommand
    extends Command {
        private DElement element;

        RemoveElementCommand(DElement element) {
            this.element = element;
        }

        public void execute() {
            DCommandFactory.this.document.removeElement(this.element);
        }

        public void undo() {
            DCommandFactory.this.document.addElement(this.element);
        }
    }

    private class SetDefaultConnectionTypeCommand
    extends Command {
        private int newType;
        private int oldType;

        SetDefaultConnectionTypeCommand(int type) {
            this.newType = type;
            this.oldType = DCommandFactory.this.document.getConnectionType();
        }

        public void execute() {
            DCommandFactory.this.document.setConnectionType(this.newType);
        }

        public void undo() {
            DCommandFactory.this.document.setConnectionType(this.oldType);
        }
    }

    private class SetDefaultNodeTypeCommand
    extends Command {
        private int newType;
        private int oldType;

        SetDefaultNodeTypeCommand(int type) {
            this.newType = type;
            this.oldType = DCommandFactory.this.document.getNodeType();
        }

        public void execute() {
            DCommandFactory.this.document.setNodeType(this.newType);
        }

        public void undo() {
            DCommandFactory.this.document.setNodeType(this.oldType);
        }
    }

    private class SetSizeCommand
    extends Command {
        private DNode connection;
        private Dimension newSize;
        private Dimension oldSize;

        SetSizeCommand(DNode connection, Dimension size) {
            this.connection = connection;
            this.newSize = size;
            this.oldSize = connection.getSize();
        }

        public void execute() {
            DCommandFactory.this.document.setSize(this.connection, this.newSize);
        }

        public void undo() {
            DCommandFactory.this.document.setSize(this.connection, this.oldSize);
        }
    }

    private class SetLocationCommand
    extends Command {
        private DNode connection;
        private Point newLocation;
        private Point oldLocation;

        SetLocationCommand(DNode connection, Point location) {
            this.connection = connection;
            this.newLocation = location;
            this.oldLocation = connection.getLocation();
        }

        public void execute() {
            DCommandFactory.this.document.setLocation(this.connection, this.newLocation);
        }

        public void undo() {
            DCommandFactory.this.document.setLocation(this.connection, this.oldLocation);
        }
    }

    private class SetBoundsCommand
    extends Command {
        private DNode connection;
        private Rectangle newBounds;
        private Rectangle oldBounds;

        SetBoundsCommand(DNode connection, Rectangle bounds) {
            this.connection = connection;
            this.newBounds = bounds;
            this.oldBounds = connection.getBounds();
        }

        public void execute() {
            DCommandFactory.this.document.setBounds(this.connection, this.newBounds);
        }

        public void undo() {
            DCommandFactory.this.document.setBounds(this.connection, this.oldBounds);
        }
    }

    private class SetNodeTypeCommand
    extends Command {
        private DNode node;
        private int newType;
        private int oldType;

        SetNodeTypeCommand(DNode node, int type) {
            this.node = node;
            this.newType = type;
            this.oldType = node.getNodeType();
        }

        public void execute() {
            DCommandFactory.this.document.setNodeType(this.node, this.newType);
        }

        public void undo() {
            DCommandFactory.this.document.setNodeType(this.node, this.oldType);
        }
    }

    private class SetConnectionTypeCommand
    extends Command {
        private DConnection connection;
        private int newType;
        private int oldType;

        SetConnectionTypeCommand(DConnection connection, int type) {
            this.connection = connection;
            this.newType = type;
            this.oldType = connection.getConnectionType();
        }

        public void execute() {
            DCommandFactory.this.document.setConnectionType(this.connection, this.newType);
        }

        public void undo() {
            DCommandFactory.this.document.setConnectionType(this.connection, this.oldType);
        }
    }

    private class SetSourceConnectionConstraintCommand
    extends Command {
        private DConnection target;
        private Object newType;
        private Object oldType;

        SetSourceConnectionConstraintCommand(DConnection conn, Object constraint) {
            this.target = conn;
            this.newType = constraint;
            this.oldType = conn.getSourceConstraint();
        }

        public void execute() {
            DCommandFactory.this.document.setSourceConnectionConstraint(this.target, this.newType);
        }

        public void undo() {
            DCommandFactory.this.document.setSourceConnectionConstraint(this.target, this.oldType);
        }
    }

    private class SetTargetConnectionConstraintCommand
    extends Command {
        private DConnection target;
        private Object newType;
        private Object oldType;

        SetTargetConnectionConstraintCommand(DConnection conn, Object constraint) {
            this.target = conn;
            this.newType = constraint;
            this.oldType = conn.getTargetConstraint();
        }

        public void execute() {
            DCommandFactory.this.document.setTargetConnectionConstraint(this.target, this.newType);
        }

        public void undo() {
            DCommandFactory.this.document.setTargetConnectionConstraint(this.target, this.oldType);
        }
    }

    private class AddBendpointCommand
    extends Command {
        private DConnection connection;
        private DRelativePoint bendpoint;
        private int index;

        AddBendpointCommand(DConnection connection, DRelativePoint bendpoint, int index) {
            this.connection = connection;
            this.bendpoint = bendpoint;
            this.index = index;
        }

        public void execute() {
            DCommandFactory.this.document.addBendpoint(this.connection, this.bendpoint, this.index);
        }

        public void undo() {
            DCommandFactory.this.document.removeBendpoint(this.connection, this.index);
        }
    }

    private class RemoveBendpointCommand
    extends Command {
        private DConnection connection;
        private int index;
        private DRelativePoint oldPoint;

        RemoveBendpointCommand(DConnection connection, int index) {
            this.connection = connection;
            this.index = index;
            this.oldPoint = (DRelativePoint)connection.getBendpoints().get(index);
        }

        public void execute() {
            DCommandFactory.this.document.removeBendpoint(this.connection, this.index);
        }

        public void undo() {
            DCommandFactory.this.document.addBendpoint(this.connection, this.oldPoint, this.index);
        }
    }

    private class MoveBendpointCommand
    extends Command {
        private DConnection connection;
        private int index;
        private DRelativePoint oldPoint;
        private DRelativePoint newPoint;

        MoveBendpointCommand(DConnection connection, int index, DRelativePoint point) {
            this.connection = connection;
            this.index = index;
            this.newPoint = point;
            this.oldPoint = (DRelativePoint)connection.getBendpoints().get(index);
        }

        public void execute() {
            DCommandFactory.this.document.moveBendpoint(this.connection, this.index, this.newPoint);
        }

        public void undo() {
            DCommandFactory.this.document.moveBendpoint(this.connection, this.index, this.oldPoint);
        }
    }

    private class ReconnectCommand
    extends Command {
        private DConnection connection;
        private DNode newSource;
        private DNode newTarget;
        private DNode oldSource;
        private DNode oldTarget;

        ReconnectCommand(DConnection connection, DNode source, DNode target) {
            this.connection = connection;
            this.newSource = source;
            this.newTarget = target;
            this.oldTarget = connection.getTarget();
            this.oldSource = connection.getSource();
        }

        public void execute() {
            DCommandFactory.this.document.reconnectConnection(this.connection, this.newSource, this.newTarget);
        }

        public void undo() {
            DCommandFactory.this.document.reconnectConnection(this.connection, this.oldSource, this.oldTarget);
        }
    }

    private class SetLabelLocationCommand
    extends Command {
        private DLabel label;
        private DRelativePoint newLocation;
        private DRelativePoint oldLocation;

        SetLabelLocationCommand(DLabel label, DRelativePoint location) {
            this.label = label;
            this.newLocation = location;
            this.oldLocation = label.getLocation();
        }

        public void execute() {
            DCommandFactory.this.document.setLocation(this.label, this.newLocation);
        }

        public void undo() {
            DCommandFactory.this.document.setLocation(this.label, this.oldLocation);
        }
    }
}

