/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.model;

import java.io.IOException;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectInputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectOutputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLSerializable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class DRelativePoint
implements XMLSerializable {
    public static final Dimension DEFAULT_SIZE = new Dimension(0, 0);
    public static final float DEFAULT_WEIGHT = 0.5f;
    private Dimension d1;
    private Dimension d2;
    private float weight;

    public static DRelativePoint createInstance(Point p, Point pSrc, Point pTgt) {
        Dimension d1 = p.getDifference(pSrc);
        Dimension d2 = p.getDifference(pTgt);
        float f1 = (float)p.getDistance(pSrc);
        float f2 = (float)p.getDistance(pTgt);
        float distance = f1 + f2;
        float weight = f1 / distance;
        return new DRelativePoint(d1, d2, weight);
    }

    public DRelativePoint() {
        this(DEFAULT_SIZE, DEFAULT_SIZE, 0.5f);
    }

    public DRelativePoint(Dimension d1, Dimension d2) {
        this(d1, d2, 0.5f);
    }

    public DRelativePoint(float weight) {
        this(DEFAULT_SIZE, DEFAULT_SIZE, weight);
    }

    public DRelativePoint(Dimension d1, Dimension d2, float weight) {
        this.d1 = d1;
        this.d2 = d2;
        this.weight = weight;
    }

    public Dimension getD1() {
        return this.d1;
    }

    public Dimension getD2() {
        return this.d2;
    }

    public float getWeight() {
        return this.weight;
    }

    public String getTagName() {
        return "RelativePoint";
    }

    public void readObject(XMLObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
    }

    public void writeObject(XMLObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
    }
}

