/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DDocument;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.XConnection;
import diagrammodelfw.xml.model.XDimension;
import diagrammodelfw.xml.model.XDocument;
import diagrammodelfw.xml.model.XLabel;
import diagrammodelfw.xml.model.XNode;
import diagrammodelfw.xml.model.XPoint;
import diagrammodelfw.xml.model.XRelativePoint;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class DXMLOutput {
    private static final IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();

    public synchronized XDocument process(DDocument doc) {
        return this.createXDocument(doc);
    }

    private XDocument createXDocument(DDocument dDocument) {
        XDocument xDocument = factory.createXDocument();
        xDocument.setConnectionType(dDocument.getConnectionType());
        xDocument.setNodeType(dDocument.getNodeType());
        xDocument.setNodes(factory.createXNodes());
        Iterator i = dDocument.getAllNodes().iterator();
        while (i.hasNext()) {
            DNode dNode = (DNode)((Object)i.next());
            xDocument.getNodes().addNode(this.createXNode(dNode));
        }
        xDocument.setConnections(factory.createXConnections());
        i = dDocument.getAllConnections().iterator();
        while (i.hasNext()) {
            DConnection dConnection = (DConnection)((Object)i.next());
            xDocument.getConnections().addConnection(this.createXConnection(dConnection));
        }
        xDocument.setLabels(factory.createXLabels());
        i = dDocument.getAllLabels().iterator();
        while (i.hasNext()) {
            DLabel dLabel = (DLabel)((Object)i.next());
            xDocument.getLabels().addLabel(this.createXLabel(dLabel));
        }
        return xDocument;
    }

    private IRNode createXElement(DElement dElement) {
        if (dElement == null) {
            return null;
        }
        if (dElement instanceof DNode) {
            return this.createXNode((DNode)dElement);
        }
        if (dElement instanceof DConnection) {
            return this.createXConnection((DConnection)dElement);
        }
        if (dElement instanceof DLabel) {
            return this.createXLabel((DLabel)dElement);
        }
        throw new RuntimeException("Illegal Element Type for Model to XML");
    }

    private XNode createXNode(DNode dNode) {
        XNode xNode = factory.createXNode();
        xNode.setId(dNode.getId());
        xNode.setNodeType(dNode.getNodeType());
        xNode.setPoint(this.createXPoint(dNode.getLocation()));
        xNode.setDimension(this.createXDimension(dNode.getSize()));
        return xNode;
    }

    private XConnection createXConnection(DConnection dConnection) {
        XConnection xConnection = factory.createXConnection();
        xConnection.setId(dConnection.getId());
        xConnection.setConnectionType(dConnection.getConnectionType());
        xConnection.setSourceId(dConnection.getSource().getId());
        xConnection.setTargetId(dConnection.getTarget().getId());
        xConnection.setBendpoints(factory.createXBendpoints());
        Iterator i = dConnection.getBendpoints().iterator();
        while (i.hasNext()) {
            xConnection.getBendpoints().addRelativePoint(this.createXRelativePoint((DRelativePoint)i.next()));
        }
        return xConnection;
    }

    private XLabel createXLabel(DLabel dLabel) {
        XLabel xLabel = factory.createXLabel();
        xLabel.setId(dLabel.getId());
        xLabel.setParentId(dLabel.getParent().getId());
        xLabel.setRelativePoint(this.createXRelativePoint(dLabel.getLocation()));
        return xLabel;
    }

    private XPoint createXPoint(Point point) {
        XPoint xPoint = factory.createXPoint();
        xPoint.setX(point.x);
        xPoint.setY(point.y);
        return xPoint;
    }

    private XDimension createXDimension(Dimension d) {
        XDimension xDimension = factory.createXDimension();
        xDimension.setWidth(d.width);
        xDimension.setHeight(d.height);
        return xDimension;
    }

    private XRelativePoint createXRelativePoint(DRelativePoint point) {
        XRelativePoint xPoint = factory.createXRelativePoint();
        XDimension x1 = this.createXDimension(point.getD1());
        XDimension x2 = this.createXDimension(point.getD2());
        xPoint.setDimension1(x1);
        xPoint.setDimension2(x2);
        xPoint.setWeight(point.getWeight());
        return xPoint;
    }
}

