/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml.model;

import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.RStack;
import diagrammodelfw.xml.model.UJAXP;
import diagrammodelfw.xml.model.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XDimension
implements Serializable,
Cloneable,
IRNode {
    private int width_;
    private int height_;
    private IRNode parentRNode_;

    public XDimension() {
    }

    public XDimension(XDimension source) {
        this.setup(source);
    }

    public XDimension(RStack stack) {
        this.setup(stack);
    }

    public XDimension(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XDimension(Element element) {
        this.setup(element);
    }

    public XDimension(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XDimension(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XDimension(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XDimension(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XDimension(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XDimension(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XDimension source) {
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        DiagramModelFwFactory.getFactory();
        new RStack(element);
        this.width_ = URelaxer.getAttributePropertyAsInt(element, "width");
        this.height_ = URelaxer.getAttributePropertyAsInt(element, "height");
    }

    public Object clone() {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        return factory.createXDimension(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("dimension");
        URelaxer.setAttributePropertyByInt(element, "width", this.width_);
        URelaxer.setAttributePropertyByInt(element, "height", this.height_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final int getWidth() {
        return this.width_;
    }

    public final void setWidth(int width) {
        this.width_ = width;
    }

    public final int getHeight() {
        return this.height_;
    }

    public final void setHeight(int height) {
        this.height_ = height;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<dimension");
        buffer.append(" width=\"");
        buffer.append(URelaxer.getString(this.getWidth()));
        buffer.append("\"");
        buffer.append(" height=\"");
        buffer.append(URelaxer.getString(this.getHeight()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</dimension>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<dimension");
        buffer.write(" width=\"");
        buffer.write(URelaxer.getString(this.getWidth()));
        buffer.write("\"");
        buffer.write(" height=\"");
        buffer.write(URelaxer.getString(this.getHeight()));
        buffer.write("\"");
        buffer.write(">");
        buffer.write("</dimension>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<dimension");
        buffer.print(" width=\"");
        buffer.print(URelaxer.getString(this.getWidth()));
        buffer.print("\"");
        buffer.print(" height=\"");
        buffer.print(URelaxer.getString(this.getHeight()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</dimension>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getWidthAsString() {
        return URelaxer.getString(this.getWidth());
    }

    public String getHeightAsString() {
        return URelaxer.getString(this.getHeight());
    }

    public void setWidthByString(String string) {
        this.setWidth(Integer.parseInt(string));
    }

    public void setHeightByString(String string) {
        this.setHeight(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "dimension")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "width")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "height")) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XDimension.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XDimension.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

