/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml.model;

import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.RStack;
import diagrammodelfw.xml.model.UJAXP;
import diagrammodelfw.xml.model.URelaxer;
import diagrammodelfw.xml.model.XConnections;
import diagrammodelfw.xml.model.XLabels;
import diagrammodelfw.xml.model.XNodes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XDocument
implements Serializable,
Cloneable,
IRNode {
    private int connectionType_;
    private int nodeType_;
    private XNodes nodes_;
    private XConnections connections_;
    private XLabels labels_;
    private IRNode parentRNode_;

    public XDocument() {
    }

    public XDocument(XDocument source) {
        this.setup(source);
    }

    public XDocument(RStack stack) {
        this.setup(stack);
    }

    public XDocument(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XDocument(Element element) {
        this.setup(element);
    }

    public XDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XDocument(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XDocument(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XDocument(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XDocument(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XDocument source) {
        this.setConnectionType(source.getConnectionType());
        this.setNodeType(source.getNodeType());
        this.setNodes(source.getNodes());
        this.setConnections(source.getConnections());
        this.setLabels(source.getLabels());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        RStack stack = new RStack(element);
        this.connectionType_ = URelaxer.getAttributePropertyAsInt(element, "connectionType");
        this.nodeType_ = URelaxer.getAttributePropertyAsInt(element, "nodeType");
        if (XNodes.isMatch(stack)) {
            this.setNodes(factory.createXNodes(stack));
        }
        if (XConnections.isMatch(stack)) {
            this.setConnections(factory.createXConnections(stack));
        }
        if (XLabels.isMatch(stack)) {
            this.setLabels(factory.createXLabels(stack));
        }
    }

    public Object clone() {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        return factory.createXDocument(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("document");
        URelaxer.setAttributePropertyByInt(element, "connectionType", this.connectionType_);
        URelaxer.setAttributePropertyByInt(element, "nodeType", this.nodeType_);
        if (this.nodes_ != null) {
            this.nodes_.makeElement(element);
        }
        if (this.connections_ != null) {
            this.connections_.makeElement(element);
        }
        if (this.labels_ != null) {
            this.labels_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final int getConnectionType() {
        return this.connectionType_;
    }

    public final void setConnectionType(int connectionType) {
        this.connectionType_ = connectionType;
    }

    public final int getNodeType() {
        return this.nodeType_;
    }

    public final void setNodeType(int nodeType) {
        this.nodeType_ = nodeType;
    }

    public final XNodes getNodes() {
        return this.nodes_;
    }

    public final void setNodes(XNodes nodes) {
        this.nodes_ = nodes;
        if (nodes != null) {
            nodes.rSetParentRNode(this);
        }
    }

    public final XConnections getConnections() {
        return this.connections_;
    }

    public final void setConnections(XConnections connections) {
        this.connections_ = connections;
        if (connections != null) {
            connections.rSetParentRNode(this);
        }
    }

    public final XLabels getLabels() {
        return this.labels_;
    }

    public final void setLabels(XLabels labels) {
        this.labels_ = labels;
        if (labels != null) {
            labels.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<document");
        buffer.append(" connectionType=\"");
        buffer.append(URelaxer.getString(this.getConnectionType()));
        buffer.append("\"");
        buffer.append(" nodeType=\"");
        buffer.append(URelaxer.getString(this.getNodeType()));
        buffer.append("\"");
        buffer.append(">");
        if (this.nodes_ != null) {
            this.nodes_.makeTextElement(buffer);
        }
        if (this.connections_ != null) {
            this.connections_.makeTextElement(buffer);
        }
        if (this.labels_ != null) {
            this.labels_.makeTextElement(buffer);
        }
        buffer.append("</document>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<document");
        buffer.write(" connectionType=\"");
        buffer.write(URelaxer.getString(this.getConnectionType()));
        buffer.write("\"");
        buffer.write(" nodeType=\"");
        buffer.write(URelaxer.getString(this.getNodeType()));
        buffer.write("\"");
        buffer.write(">");
        if (this.nodes_ != null) {
            this.nodes_.makeTextElement(buffer);
        }
        if (this.connections_ != null) {
            this.connections_.makeTextElement(buffer);
        }
        if (this.labels_ != null) {
            this.labels_.makeTextElement(buffer);
        }
        buffer.write("</document>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<document");
        buffer.print(" connectionType=\"");
        buffer.print(URelaxer.getString(this.getConnectionType()));
        buffer.print("\"");
        buffer.print(" nodeType=\"");
        buffer.print(URelaxer.getString(this.getNodeType()));
        buffer.print("\"");
        buffer.print(">");
        if (this.nodes_ != null) {
            this.nodes_.makeTextElement(buffer);
        }
        if (this.connections_ != null) {
            this.connections_.makeTextElement(buffer);
        }
        if (this.labels_ != null) {
            this.labels_.makeTextElement(buffer);
        }
        buffer.print("</document>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getConnectionTypeAsString() {
        return URelaxer.getString(this.getConnectionType());
    }

    public String getNodeTypeAsString() {
        return URelaxer.getString(this.getNodeType());
    }

    public void setConnectionTypeByString(String string) {
        this.setConnectionType(Integer.parseInt(string));
    }

    public void setNodeTypeByString(String string) {
        this.setNodeType(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.nodes_ != null) {
            classNodes.add(this.nodes_);
        }
        if (this.connections_ != null) {
            classNodes.add(this.connections_);
        }
        if (this.labels_ != null) {
            classNodes.add(this.labels_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "document")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "connectionType")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "nodeType")) {
            return false;
        }
        if (!XNodes.isMatchHungry(target)) {
            return false;
        }
        if (!XConnections.isMatchHungry(target)) {
            return false;
        }
        if (!XLabels.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XDocument.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XDocument.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

