/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml.model;

import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.RStack;
import diagrammodelfw.xml.model.UJAXP;
import diagrammodelfw.xml.model.URelaxer;
import diagrammodelfw.xml.model.XRelativePoint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XLabel
implements Serializable,
Cloneable,
IRNode {
    private String id_;
    private String parentId_;
    private XRelativePoint relativePoint_;
    private IRNode parentRNode_;

    public XLabel() {
        this.id_ = "";
        this.parentId_ = "";
    }

    public XLabel(XLabel source) {
        this.setup(source);
    }

    public XLabel(RStack stack) {
        this.setup(stack);
    }

    public XLabel(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XLabel(Element element) {
        this.setup(element);
    }

    public XLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XLabel source) {
        this.setId(source.getId());
        this.setParentId(source.getParentId());
        this.setRelativePoint(source.getRelativePoint());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.parentId_ = URelaxer.getAttributePropertyAsString(element, "parentId");
        if (XRelativePoint.isMatch(stack)) {
            this.setRelativePoint(factory.createXRelativePoint(stack));
        }
    }

    public Object clone() {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        return factory.createXLabel(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("label");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        URelaxer.setAttributePropertyByString(element, "parentId", this.parentId_);
        if (this.relativePoint_ != null) {
            this.relativePoint_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getParentId() {
        return this.parentId_;
    }

    public final void setParentId(String parentId) {
        this.parentId_ = parentId;
    }

    public final XRelativePoint getRelativePoint() {
        return this.relativePoint_;
    }

    public final void setRelativePoint(XRelativePoint relativePoint) {
        this.relativePoint_ = relativePoint;
        if (relativePoint != null) {
            relativePoint.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<label");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.parentId_ != null) {
            buffer.append(" parentId=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getParentId())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.relativePoint_ != null) {
            this.relativePoint_.makeTextElement(buffer);
        }
        buffer.append("</label>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<label");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.parentId_ != null) {
            buffer.write(" parentId=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getParentId())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.relativePoint_ != null) {
            this.relativePoint_.makeTextElement(buffer);
        }
        buffer.write("</label>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<label");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.parentId_ != null) {
            buffer.print(" parentId=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getParentId())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.relativePoint_ != null) {
            this.relativePoint_.makeTextElement(buffer);
        }
        buffer.print("</label>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getParentIdAsString() {
        return URelaxer.getString(this.getParentId());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setParentIdByString(String string) {
        this.setParentId(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<XRelativePoint> classNodes = new ArrayList<XRelativePoint>();
        if (this.relativePoint_ != null) {
            classNodes.add(this.relativePoint_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "label")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "parentId")) {
            return false;
        }
        if (!XRelativePoint.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XLabel.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XLabel.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

