/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml.model;

import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.RStack;
import diagrammodelfw.xml.model.UJAXP;
import diagrammodelfw.xml.model.URelaxer;
import diagrammodelfw.xml.model.XDimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XRelativePoint
implements Serializable,
Cloneable,
IRNode {
    private float weight_;
    private XDimension dimension1_;
    private XDimension dimension2_;
    private IRNode parentRNode_;

    public XRelativePoint() {
    }

    public XRelativePoint(XRelativePoint source) {
        this.setup(source);
    }

    public XRelativePoint(RStack stack) {
        this.setup(stack);
    }

    public XRelativePoint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XRelativePoint(Element element) {
        this.setup(element);
    }

    public XRelativePoint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XRelativePoint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XRelativePoint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XRelativePoint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XRelativePoint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XRelativePoint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XRelativePoint source) {
        this.setWeight(source.getWeight());
        this.setDimension1(source.getDimension1());
        this.setDimension2(source.getDimension2());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        RStack stack = new RStack(element);
        this.weight_ = URelaxer.getAttributePropertyAsFloat(element, "weight");
        if (XDimension.isMatch(stack)) {
            this.setDimension1(factory.createXDimension(stack));
        }
        if (XDimension.isMatch(stack)) {
            this.setDimension2(factory.createXDimension(stack));
        }
    }

    public Object clone() {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        return factory.createXRelativePoint(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("relativePoint");
        URelaxer.setAttributePropertyByFloat(element, "weight", this.weight_);
        if (this.dimension1_ != null) {
            this.dimension1_.makeElement(element);
        }
        if (this.dimension2_ != null) {
            this.dimension2_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final float getWeight() {
        return this.weight_;
    }

    public final void setWeight(float weight) {
        this.weight_ = weight;
    }

    public final XDimension getDimension1() {
        return this.dimension1_;
    }

    public final void setDimension1(XDimension dimension1) {
        this.dimension1_ = dimension1;
        if (dimension1 != null) {
            dimension1.rSetParentRNode(this);
        }
    }

    public final XDimension getDimension2() {
        return this.dimension2_;
    }

    public final void setDimension2(XDimension dimension2) {
        this.dimension2_ = dimension2;
        if (dimension2 != null) {
            dimension2.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<relativePoint");
        buffer.append(" weight=\"");
        buffer.append(URelaxer.getString(this.getWeight()));
        buffer.append("\"");
        buffer.append(">");
        if (this.dimension1_ != null) {
            this.dimension1_.makeTextElement(buffer);
        }
        if (this.dimension2_ != null) {
            this.dimension2_.makeTextElement(buffer);
        }
        buffer.append("</relativePoint>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<relativePoint");
        buffer.write(" weight=\"");
        buffer.write(URelaxer.getString(this.getWeight()));
        buffer.write("\"");
        buffer.write(">");
        if (this.dimension1_ != null) {
            this.dimension1_.makeTextElement(buffer);
        }
        if (this.dimension2_ != null) {
            this.dimension2_.makeTextElement(buffer);
        }
        buffer.write("</relativePoint>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<relativePoint");
        buffer.print(" weight=\"");
        buffer.print(URelaxer.getString(this.getWeight()));
        buffer.print("\"");
        buffer.print(">");
        if (this.dimension1_ != null) {
            this.dimension1_.makeTextElement(buffer);
        }
        if (this.dimension2_ != null) {
            this.dimension2_.makeTextElement(buffer);
        }
        buffer.print("</relativePoint>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getWeightAsString() {
        return URelaxer.getString(this.getWeight());
    }

    public void setWeightByString(String string) {
        this.setWeight(Float.parseFloat(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<XDimension> classNodes = new ArrayList<XDimension>();
        if (this.dimension1_ != null) {
            classNodes.add(this.dimension1_);
        }
        if (this.dimension2_ != null) {
            classNodes.add(this.dimension2_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "relativePoint")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "weight")) {
            return false;
        }
        if (!XDimension.isMatchHungry(target)) {
            return false;
        }
        if (!XDimension.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XRelativePoint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XRelativePoint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

