/*
 * Decompiled with CFR 0.152.
 */
package trier;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import trier.TDocumentSerializer;
import trier.TrierException;
import trier.diagrameditor.EDocumentSerializer;
import trier.model.core.TDocument;

public class Trier {
    private IFolder getModelRootFolder;
    private static final Logger logger;
    public static final String MODEL_FILE_NAME = "modeldb.xml";
    protected static Trier INSTANCE;
    private Map documents = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.Trier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public static Trier getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Trier();
        }
        return INSTANCE;
    }

    protected Trier() {
    }

    public TDocument getDocument(IProject project, Class callerClass) {
        if (!this.documents.containsKey(project)) {
            this.createDocument(project, callerClass);
        }
        return (TDocument)this.documents.get(project);
    }

    public void saveDocument(IProject project, IProgressMonitor progressMonitor) throws Exception {
        TDocument document = this.getDocument(project, this.getClass());
        EDocumentSerializer serializer = new EDocumentSerializer();
        serializer.saveObject(new TDocumentSerializer(), document, this.getModelDBFile(project), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
        IFolder folder = this.getModelRootContainer(project).getFolder((IPath)new Path("backup"));
        if (folder.exists()) {
            Calendar cal = Calendar.getInstance();
            String name = MODEL_FILE_NAME + cal.get(1) + cal.get(2) + cal.get(5) + cal.get(11) + ".bak";
            IFile backupFile = folder.getFile(name);
            serializer.saveObject(new TDocumentSerializer(), document, backupFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
        }
    }

    public TDocument recreateDocument(IProject project, Class callerClass) {
        this.createDocument(project, callerClass);
        return (TDocument)this.documents.get(project);
    }

    private void createDocument(IProject project, Class callerClass) {
        TDocument newDocument = null;
        try {
            IFile file = this.getModelDBFile(project);
            newDocument = file.exists() ? this.loadDocument(file, callerClass) : this.createNewDocument();
        }
        catch (Exception exception) {
            logger.warn((Object)("Cannot Load TDocument project = " + project + "callerClass = " + callerClass));
            newDocument = this.createNewDocument();
        }
        this.documents.put(project, newDocument);
    }

    protected TDocument createNewDocument() {
        TDocument tdoc = new TDocument();
        tdoc.initializeDefaultModels();
        return tdoc;
    }

    protected TDocument loadDocument(IFile file, Class callerClass) throws Exception {
        TDocumentSerializer serializer = new TDocumentSerializer();
        TDocument tdoc = (TDocument)serializer.loadObject(file.getContents(), callerClass);
        return tdoc;
    }

    public IFile getModelDBFile(IProject project) throws Exception {
        IContainer container = this.getModelRootContainer(project);
        if (!container.exists()) {
            ((IFolder)container).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return container.getFile((IPath)new Path(MODEL_FILE_NAME));
    }

    public IContainer getModelRootContainer(IProject project) {
        IJavaProject myJavaProject = JavaCore.create((IProject)project);
        if (myJavaProject == null) {
            throw new TrierException("isn't JavaProject");
        }
        try {
            IPackageFragmentRoot[] fragmentRoots = myJavaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < fragmentRoots.length) {
                if (fragmentRoots[i].getKind() == 1) {
                    if (fragmentRoots[i].getElementName().equals("")) {
                        return project;
                    }
                    return project.getFolder(fragmentRoots[i].getElementName());
                }
                ++i;
            }
            throw new TrierException("this project don't have source folder.");
        }
        catch (JavaModelException javaModelException) {
            throw new TrierException("search source folder failed." + project);
        }
    }

    public IPath getModelRootFolderPath(IFile file) {
        IContainer modelRoot = this.getModelRootContainer(file.getProject());
        return modelRoot.getFullPath();
    }
}

