/*
 * Decompiled with CFR 0.152.
 */
package trier.activitydiagram.figure;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import trier.TrierPlugin;
import trier.activitydiagram.ADConstants;
import trier.diagrameditor.figure.ENodeFigure;
import trier.model.state.TActivityState;

public class ADActivityFigure
extends ENodeFigure {
    private Figure titleLayer = new Figure();
    private Label titleLabel = new Label();
    public static final int xMargin = 10;
    public static final int yMargin = 10;
    private int layoutCurrentHeight = 0;

    public ADActivityFigure() {
        this.initialize();
        this.initializeComponents();
    }

    protected void initialize() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder(null);
    }

    protected void initializeComponents() {
        DelegatingLayout titleLayout = new DelegatingLayout();
        this.titleLayer.setLayoutManager((LayoutManager)titleLayout);
        this.titleLayer.setForegroundColor(ADConstants.DEFAULT_STATE_PEN_COLOR);
        this.add((IFigure)this.titleLayer);
        this.titleLayer.add((IFigure)this.titleLabel, (Object)new TitleLabelLocator());
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void updateVisual(TActivityState activityState) {
        this.titleLabel.setText(activityState.getName());
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.titleLayer.setBounds(r);
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (index == -1) {
            super.add(figure, constraint, index);
        } else if (figure == this.titleLayer) {
            super.add(figure, constraint, 0);
        } else {
            super.add(figure, constraint, index + 1);
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
        g.setBackgroundColor(TrierPlugin.DEFAULT_CLASS_FILL_COLOR);
        g.setLineWidth(1);
        Rectangle r = super.getBounds();
        r = this.getBoundsForDraw(1);
        this.drawAcivityState(g, r);
    }

    private void drawAcivityState(Graphics g, Rectangle r) {
        g.fillRectangle(r);
        int cornerLength = r.height / 2;
        g.drawLine(r.x + cornerLength, r.y, r.x + r.width - cornerLength, r.y);
        g.drawLine(r.x + cornerLength, r.y + r.height, r.x + r.width - cornerLength, r.y + r.height);
        g.drawArc(r.getTopLeft().x, r.getTopLeft().y, cornerLength * 2, r.height, 90, 180);
        g.drawArc(r.getTopRight().x - cornerLength * 2, r.getTopRight().y, cornerLength * 2, r.height, 270, 180);
    }

    private int layoutGetWidth() {
        Rectangle r = this.getBounds();
        return r.width;
    }

    private int layoutGetHeight() {
        Rectangle r = this.getBounds();
        return r.height;
    }

    private Point layoutGetLocation() {
        Rectangle r = this.getBounds();
        int x = r.x + 10;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    private Point layoutGetLocationNoMargin() {
        Rectangle r = this.getBounds();
        int x = r.x;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    class TitleLabelLocator
    implements Locator {
        TitleLabelLocator() {
        }

        public void relocate(IFigure target) {
            ADActivityFigure.this.layoutCurrentHeight = 10;
            int width = ADActivityFigure.this.layoutGetWidth() - 20;
            int height = target.getPreferredSize().height;
            target.setBounds(new Rectangle(ADActivityFigure.this.layoutGetLocation(), new Dimension(width, height)));
            ADActivityFigure aDActivityFigure = ADActivityFigure.this;
            aDActivityFigure.layoutCurrentHeight = aDActivityFigure.layoutCurrentHeight + height;
        }
    }
}

