/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DRelativePoint;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import trier.classdiagram.CDConstants;
import trier.classdiagram.edit.property.CDEditDialog;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;
import trier.model.command.TCommand;
import trier.model.core.TAggregationKind;
import trier.model.core.TAssociation;
import trier.model.core.TAssociationEnd;
import trier.model.core.TClass;
import trier.model.core.TMultiplicity;
import trier.model.core.TRole;

public class CDAssociationEditDialog
extends CDEditDialog {
    private static int CLASS_WIDTH = 150;
    private static int CLASS_HEIGHT = 160;
    private static int ASSOCIATION_LENGTH = 250;
    private Canvas sourceClassView;
    private Combo sourceMultiplicityCombo;
    private Text sourceRoleText;
    private Button sourceNoneButton;
    private Button sourceNavigableButton;
    private Button sourceAggregateButton;
    private Button sourceCompositeButton;
    private Canvas targetClassView;
    private Text targetRoleText;
    private Combo targetMultiplicityCombo;
    private Button targetNoneButton;
    private Button targetNavigableButton;
    private Button targetAggregateButton;
    private Button targetCompositeButton;
    private Canvas associationView;
    private DRelativePoint sourceRoleCash = CDConstants.ROLE_SOURCE_RELATIVE_POINT;
    private DRelativePoint targetRoleCash = CDConstants.ROLE_TARGET_RELATIVE_POINT;
    private DRelativePoint sourceMultiplicityCash = CDConstants.MULTIPLICITY_SOURCE_RELATIVE_POINT;
    private DRelativePoint targetMultiplicityCash = CDConstants.MULTIPLICITY_TARGET_RELATIVE_POINT;

    public CDAssociationEditDialog(EEditDomain domain, EElement element) {
        super(domain, element);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Association Specification");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.initializeViewComposite(composite);
        this.initializeAssociationEndSettingComposite(composite);
        composite.pack();
        composite.redraw();
        return composite;
    }

    private void initializeViewComposite(Composite composite) {
        this.initializeSourceClassViewComposite(composite);
        this.initializeAssociationSettingComposite(composite);
        this.initializeTargetClassViewComposite(composite);
    }

    private void initializeAssociationEndSettingComposite(Composite composite) {
        this.initializeSourceAssociationEndSettingComposite(composite);
        this.initializeCenterSpaceComposite(composite);
        this.initializeTargetAssociationEndSettingComposite(composite);
    }

    private void initializeSourceClassViewComposite(Composite parent) {
        this.sourceClassView = new Canvas(parent, 0);
        GridData gridData = new GridData();
        gridData.widthHint = CLASS_WIDTH;
        gridData.heightHint = CLASS_HEIGHT;
        this.sourceClassView.setLayoutData((Object)gridData);
        this.drawClass(this.sourceClassView, this.getTAssociation().getSourceAssociationEnd().getOwner());
    }

    private void initializeAssociationSettingComposite(Composite parent) {
        Composite associationView = new Composite(parent, 0);
        GridData gridData = new GridData(1040);
        gridData.widthHint = ASSOCIATION_LENGTH;
        associationView.setLayoutData((Object)gridData);
        associationView.setLayout((Layout)new FillLayout(512));
        this.initializeRoleComposite(associationView);
        this.initializeAssociationView(associationView);
        this.initializeMultiplicityComposite(associationView);
    }

    private void initializeTargetClassViewComposite(Composite parent) {
        this.targetClassView = new Canvas(parent, 0);
        GridData gridData = new GridData();
        gridData.widthHint = CLASS_WIDTH;
        gridData.heightHint = CLASS_HEIGHT;
        this.targetClassView.setLayoutData((Object)gridData);
        this.drawClass(this.targetClassView, this.getTAssociation().getTargetAssociationEnd().getOwner());
    }

    private void initializeSourceAssociationEndSettingComposite(Composite parent) {
        TAssociationEnd associationEnd = this.getTAssociation().getSourceAssociationEnd();
        Group associationEndSettingGroup = new Group(parent, 0);
        associationEndSettingGroup.setText("Source");
        associationEndSettingGroup.setLayoutData((Object)new GridData(768));
        associationEndSettingGroup.setLayout((Layout)new RowLayout(512));
        this.sourceNoneButton = new Button((Composite)associationEndSettingGroup, 16);
        this.sourceNoneButton.setText("None");
        this.sourceNoneButton.setSelection(!associationEnd.isNavigable() && associationEnd.getAggregationKind().equals(TAggregationKind.NONE));
        this.sourceNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.sourceNoneButtonSeletcted(e);
            }
        });
        this.sourceNavigableButton = new Button((Composite)associationEndSettingGroup, 16);
        this.sourceNavigableButton.setText("Navigable");
        this.sourceNavigableButton.setSelection(associationEnd.isNavigable());
        this.sourceNavigableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.sourceNavigableButtonSeletcted(e);
            }
        });
        this.sourceAggregateButton = new Button((Composite)associationEndSettingGroup, 16);
        this.sourceAggregateButton.setText("Aggregate");
        this.sourceAggregateButton.setSelection(!associationEnd.isNavigable() && associationEnd.getAggregationKind().equals(TAggregationKind.AGGREGATION));
        this.sourceAggregateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.sourceAggregateButtonSeletcted(e);
            }
        });
        this.sourceCompositeButton = new Button((Composite)associationEndSettingGroup, 16);
        this.sourceCompositeButton.setText("Composite");
        this.sourceCompositeButton.setSelection(!associationEnd.isNavigable() && associationEnd.getAggregationKind().equals(TAggregationKind.COMPOSITION));
        this.sourceCompositeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.sourceCompositeButtonSeletcted(e);
            }
        });
    }

    private void initializeCenterSpaceComposite(Composite parent) {
        new Composite(parent, 0);
    }

    private void initializeTargetAssociationEndSettingComposite(Composite parent) {
        TAssociationEnd associationEnd = this.getTAssociation().getTargetAssociationEnd();
        Group associationEndSettingGroup = new Group(parent, 0);
        associationEndSettingGroup.setText("Target");
        associationEndSettingGroup.setLayoutData((Object)new GridData(768));
        associationEndSettingGroup.setLayout((Layout)new RowLayout(512));
        this.targetNoneButton = new Button((Composite)associationEndSettingGroup, 16);
        this.targetNoneButton.setText("None");
        this.targetNoneButton.setSelection(!associationEnd.isNavigable() && associationEnd.getAggregationKind().equals(TAggregationKind.NONE));
        this.targetNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.targetNoneButtonSeletcted(e);
            }
        });
        this.targetNavigableButton = new Button((Composite)associationEndSettingGroup, 16);
        this.targetNavigableButton.setText("Navigable");
        this.targetNavigableButton.setSelection(associationEnd.isNavigable());
        this.targetNavigableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.targetNavigableButtonSeletcted(e);
            }
        });
        this.targetAggregateButton = new Button((Composite)associationEndSettingGroup, 16);
        this.targetAggregateButton.setText("Aggregate");
        this.targetAggregateButton.setSelection(!associationEnd.isNavigable() && associationEnd.getAggregationKind().equals(TAggregationKind.AGGREGATION));
        this.targetAggregateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.targetAggregateButtonSeletcted(e);
            }
        });
        this.targetCompositeButton = new Button((Composite)associationEndSettingGroup, 16);
        this.targetCompositeButton.setText("Composite");
        this.targetCompositeButton.setSelection(!associationEnd.isNavigable() && associationEnd.getAggregationKind().equals(TAggregationKind.COMPOSITION));
        this.targetCompositeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.targetCompositeButtonSeletcted(e);
            }
        });
    }

    private void initializeRoleComposite(Composite associationView) {
        Composite roleComposite = new Composite(associationView, 0);
        roleComposite.setLayout((Layout)new GridLayout(2, false));
        this.sourceRoleText = new Text(roleComposite, 2048);
        if (!this.getSourceRole().isNull()) {
            this.sourceRoleText.setText(this.getSourceRole().getName());
        }
        this.sourceRoleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDAssociationEditDialog.this.sourceRoleChanged(e);
            }
        });
        GridData sourceData = new GridData(1576);
        sourceData.widthHint = 75;
        this.sourceRoleText.setLayoutData((Object)sourceData);
        this.targetRoleText = new Text(roleComposite, 2048);
        if (!this.getTargetRole().isNull()) {
            this.targetRoleText.setText(this.getTargetRole().getName());
        }
        this.targetRoleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDAssociationEditDialog.this.targetRoleChanged(e);
            }
        });
        GridData targetData = new GridData(1672);
        targetData.widthHint = 75;
        this.targetRoleText.setLayoutData((Object)targetData);
    }

    private void initializeAssociationView(Composite associationView) {
        this.associationView = new Canvas(associationView, 0);
        this.updateAssociationView();
    }

    private void initializeMultiplicityComposite(Composite associationView) {
        Composite multiplicityComposite = new Composite(associationView, 0);
        multiplicityComposite.setLayout((Layout)new GridLayout(2, true));
        this.sourceMultiplicityCombo = new Combo(multiplicityComposite, 0);
        this.sourceMultiplicityCombo.add("1");
        this.sourceMultiplicityCombo.add("2");
        this.sourceMultiplicityCombo.add("*");
        this.sourceMultiplicityCombo.add("1..*");
        if (!this.getSourceMultiplicity().isNull()) {
            this.sourceMultiplicityCombo.setText(this.getSourceMultiplicity().getMultiplicityRanges());
        }
        this.sourceMultiplicityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.sourceMultiplicityChanged();
            }
        });
        this.sourceMultiplicityCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDAssociationEditDialog.this.sourceMultiplicityChanged();
            }
        });
        GridData sourceData = new GridData(32);
        sourceData.widthHint = 60;
        this.sourceMultiplicityCombo.setLayoutData((Object)sourceData);
        this.targetMultiplicityCombo = new Combo(multiplicityComposite, 0);
        this.targetMultiplicityCombo.add("1");
        this.targetMultiplicityCombo.add("2");
        this.targetMultiplicityCombo.add("*");
        this.targetMultiplicityCombo.add("1..*");
        if (!this.getTargetMultiplicity().isNull()) {
            this.targetMultiplicityCombo.setText(this.getTargetMultiplicity().getMultiplicityRanges());
        }
        this.targetMultiplicityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDAssociationEditDialog.this.targetMultiplicityChanged();
            }
        });
        this.targetMultiplicityCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDAssociationEditDialog.this.targetMultiplicityChanged();
            }
        });
        GridData targetData = new GridData(128);
        targetData.widthHint = 60;
        this.targetMultiplicityCombo.setLayoutData((Object)targetData);
    }

    private void drawClass(Canvas classView, final TClass clazz) {
        classView.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String name = clazz.getName();
                Point extent = e.gc.stringExtent(name);
                e.gc.setBackground(CDAssociationEditDialog.this.getShell().getDisplay().getSystemColor(1));
                e.gc.fillRectangle(1, 1, CLASS_WIDTH - 2, CLASS_HEIGHT - 2);
                e.gc.drawRectangle(1, 1, CLASS_WIDTH - 2, CLASS_HEIGHT - 2);
                e.gc.drawText(name, (CLASS_WIDTH - 2) / 2 - extent.x / 2, (CLASS_HEIGHT - 2) / 2 - extent.y / 2);
            }
        });
    }

    private void updateAssociationView() {
        this.associationView.redraw();
        this.associationView.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.fillRectangle(CDAssociationEditDialog.this.associationView.getBounds());
                int center = ((CDAssociationEditDialog)CDAssociationEditDialog.this).associationView.getBounds().height / 2;
                int[] nArray = new int[8];
                nArray[1] = center;
                nArray[2] = 7;
                nArray[3] = center + 5;
                nArray[4] = 14;
                nArray[5] = center;
                nArray[6] = 7;
                nArray[7] = center - 5;
                int[] sourceAggregationPoints = nArray;
                int[] targetAggregationPoints = new int[]{ASSOCIATION_LENGTH, center, ASSOCIATION_LENGTH - 7, center + 5, ASSOCIATION_LENGTH - 14, center, ASSOCIATION_LENGTH - 7, center - 5};
                e.gc.drawLine(0, center, ASSOCIATION_LENGTH, center);
                if (CDAssociationEditDialog.this.getSourceAssociationEnd().isNavigable()) {
                    e.gc.drawLine(0, center, 15, center + 5);
                    e.gc.drawLine(0, center, 15, center - 5);
                } else if (CDAssociationEditDialog.this.getSourceAssociationEnd().getAggregationKind().equals(TAggregationKind.COMPOSITION)) {
                    e.gc.setBackground(CDAssociationEditDialog.this.getShell().getDisplay().getSystemColor(2));
                    e.gc.fillPolygon(sourceAggregationPoints);
                    e.gc.setBackground(CDAssociationEditDialog.this.getShell().getDisplay().getSystemColor(22));
                } else if (CDAssociationEditDialog.this.getSourceAssociationEnd().getAggregationKind().equals(TAggregationKind.AGGREGATION)) {
                    e.gc.fillPolygon(sourceAggregationPoints);
                    e.gc.drawPolygon(sourceAggregationPoints);
                }
                if (CDAssociationEditDialog.this.getTargetAssociationEnd().isNavigable()) {
                    e.gc.drawLine(ASSOCIATION_LENGTH, center, ASSOCIATION_LENGTH - 15, center + 5);
                    e.gc.drawLine(ASSOCIATION_LENGTH, center, ASSOCIATION_LENGTH - 15, center - 5);
                } else if (CDAssociationEditDialog.this.getTargetAssociationEnd().getAggregationKind().equals(TAggregationKind.COMPOSITION)) {
                    e.gc.setBackground(CDAssociationEditDialog.this.getShell().getDisplay().getSystemColor(2));
                    e.gc.fillPolygon(targetAggregationPoints);
                    e.gc.setBackground(CDAssociationEditDialog.this.getShell().getDisplay().getSystemColor(22));
                } else if (CDAssociationEditDialog.this.getTargetAssociationEnd().getAggregationKind().equals(TAggregationKind.AGGREGATION)) {
                    e.gc.fillPolygon(targetAggregationPoints);
                    e.gc.drawPolygon(targetAggregationPoints);
                }
            }
        });
    }

    private TAssociation getTAssociation() {
        return (TAssociation)this.getTModel();
    }

    private TAssociationEnd getSourceAssociationEnd() {
        return this.getTAssociation().getSourceAssociationEnd();
    }

    private TAssociationEnd getTargetAssociationEnd() {
        return this.getTAssociation().getTargetAssociationEnd();
    }

    private TRole getSourceRole() {
        return this.getTAssociation().getSourceAssociationEnd().getRole();
    }

    private TRole getTargetRole() {
        return this.getTAssociation().getTargetAssociationEnd().getRole();
    }

    private TMultiplicity getSourceMultiplicity() {
        return this.getTAssociation().getSourceAssociationEnd().getMultiplicity();
    }

    private TMultiplicity getTargetMultiplicity() {
        return this.getTAssociation().getTargetAssociationEnd().getMultiplicity();
    }

    private void sourceRoleChanged(ModifyEvent e) {
        TAssociationEnd sourceEnd = this.getTAssociation().getSourceAssociationEnd();
        String inputValue = this.sourceRoleText.getText();
        if (!inputValue.equals("")) {
            this.setRole(sourceEnd, inputValue, this.sourceRoleCash);
        } else {
            EElement eRole = (EElement)this.getCDDocument().getElementsByTElement(this.getSourceRole()).get(0);
            this.sourceRoleCash = ((DLabel)eRole.getDModel()).getLocation();
            Command command = this.getEEditDomain().createRemoveEElementFromModelCommand(this.getSourceRole());
            super.executeCommand(command);
        }
    }

    private void targetRoleChanged(ModifyEvent e) {
        TAssociationEnd targetEnd = this.getTAssociation().getTargetAssociationEnd();
        String inputValue = this.targetRoleText.getText();
        if (!inputValue.equals("")) {
            this.setRole(targetEnd, inputValue, this.targetRoleCash);
        } else {
            EElement eRole = (EElement)this.getCDDocument().getElementsByTElement(this.getTargetRole()).get(0);
            this.targetRoleCash = ((DLabel)eRole.getDModel()).getLocation();
            Command command = this.getEEditDomain().createRemoveEElementFromModelCommand(this.getTargetRole());
            super.executeCommand(command);
        }
    }

    private void sourceMultiplicityChanged() {
        TAssociationEnd sourceEnd = this.getTAssociation().getSourceAssociationEnd();
        String inputValue = this.sourceMultiplicityCombo.getText();
        if (inputValue.equals("")) {
            EElement eMultiplicity = (EElement)this.getCDDocument().getElementsByTElement(this.getSourceMultiplicity()).get(0);
            this.sourceMultiplicityCash = ((DLabel)eMultiplicity.getDModel()).getLocation();
            Command command = this.getEEditDomain().createRemoveEElementFromModelCommand(this.getSourceMultiplicity());
            super.executeCommand(command);
        } else if (TMultiplicity.isValidMultiplicity(inputValue)) {
            this.setMultiplicity(sourceEnd, inputValue, this.sourceMultiplicityCash);
        }
    }

    private void targetMultiplicityChanged() {
        TAssociationEnd targetEnd = this.getTAssociation().getTargetAssociationEnd();
        String inputValue = this.targetMultiplicityCombo.getText();
        if (inputValue.equals("")) {
            EElement eMultiplicity = (EElement)this.getCDDocument().getElementsByTElement(this.getTargetMultiplicity()).get(0);
            this.targetMultiplicityCash = ((DLabel)eMultiplicity.getDModel()).getLocation();
            Command command = this.getEEditDomain().createRemoveEElementFromModelCommand(this.getTargetMultiplicity());
            super.executeCommand(command);
        } else if (TMultiplicity.isValidMultiplicity(inputValue)) {
            this.setMultiplicity(targetEnd, inputValue, this.targetMultiplicityCash);
        }
    }

    private void sourceNoneButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getSourceAssociationEnd(), TAggregationKind.NONE);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getSourceAssociationEnd(), false);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void sourceNavigableButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getSourceAssociationEnd(), TAggregationKind.NONE);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getSourceAssociationEnd(), true);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void sourceAggregateButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getSourceAssociationEnd(), TAggregationKind.AGGREGATION);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getSourceAssociationEnd(), false);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void sourceCompositeButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getSourceAssociationEnd(), TAggregationKind.COMPOSITION);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getSourceAssociationEnd(), false);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void targetNoneButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getTargetAssociationEnd(), TAggregationKind.NONE);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getTargetAssociationEnd(), false);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void targetNavigableButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getTargetAssociationEnd(), TAggregationKind.NONE);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getTargetAssociationEnd(), true);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void targetAggregateButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getTargetAssociationEnd(), TAggregationKind.AGGREGATION);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getTargetAssociationEnd(), false);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void targetCompositeButtonSeletcted(SelectionEvent e) {
        TCommand command = this.getTCommandFactory().createSetAggregationCommand(this.getTAssociation().getTargetAssociationEnd(), TAggregationKind.COMPOSITION);
        super.executeCommand(command);
        TCommand navigableCommand = this.getTCommandFactory().createSetNavigableCommand(this.getTAssociation().getTargetAssociationEnd(), false);
        super.executeCommand(navigableCommand);
        this.updateAssociationView();
    }

    private void setRole(TAssociationEnd associationEnd, String inputValue, DRelativePoint relativePoint) {
        TRole tRole = null;
        if (associationEnd.getRole().isNull()) {
            DConnection connection = (DConnection)this.getDModel();
            EElement eRole = this.getCDDocument().createRole(connection);
            super.executeCommand(this.getEEditDomain().createAddEElementCommand(associationEnd, eRole));
            DLabel label = (DLabel)eRole.getDModel();
            super.executeCommand(this.getEEditDomain().getDCommandFactory().createSetLocationCommand(label, relativePoint));
            tRole = (TRole)eRole.getTModel();
        } else {
            tRole = associationEnd.getRole();
        }
        super.executeCommand(new ECommand(this.getTCommandFactory().createSetNameCommand(tRole, inputValue)));
    }

    private void setMultiplicity(TAssociationEnd targetEnd, String inputValue, DRelativePoint relativePoint) {
        TMultiplicity targetMultiplicity;
        if (targetEnd.getMultiplicity().isNull()) {
            DConnection connection = (DConnection)this.getDModel();
            EElement eMultiplicity = this.getCDDocument().createMuliplicity(connection);
            super.executeCommand(this.getEEditDomain().createAddEElementCommand(targetEnd, eMultiplicity));
            DLabel label = (DLabel)eMultiplicity.getDModel();
            super.executeCommand(this.getEEditDomain().getDCommandFactory().createSetLocationCommand(label, relativePoint));
            targetMultiplicity = (TMultiplicity)eMultiplicity.getTModel();
        } else {
            targetMultiplicity = targetEnd.getMultiplicity();
        }
        super.executeCommand(new ECommand(this.getTCommandFactory().createSetMultiplicityRangeCommand(targetMultiplicity, inputValue)));
    }
}

