/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import trier.classdiagram.edit.property.CDAttributeTableEditorComposite;
import trier.classdiagram.edit.property.CDModelElementTableEditor;
import trier.classdiagram.edit.property.ComboTextBoxCellEditor;
import trier.model.core.TAttribute;
import trier.model.core.TClass;
import trier.model.core.TClassifier;
import trier.model.core.TElement;
import trier.model.core.TVisibilityKind;

public class CDAttributeTableEditor
extends CDModelElementTableEditor {
    private CDAttributeTableEditorComposite parent;

    public CDAttributeTableEditor(CDAttributeTableEditorComposite parent, TElement element) {
        super(parent, element);
        this.parent = parent;
    }

    protected String[] getColumnNames() {
        return new String[]{"Visibility", "Type", "Name"};
    }

    protected int[] getColumnWidth() {
        return new int[]{130, 130, 130};
    }

    protected Object getElements() {
        return this.getTClass().getAttributes();
    }

    private TClass getTClass() {
        return (TClass)this.getModelElement();
    }

    protected CellEditor[] getCellEditors() {
        Table table = this.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.getColumnNames().length];
        editors[0] = new ComboBoxCellEditor((Composite)table, this.VISIBILITIES);
        editors[1] = new ComboTextBoxCellEditor((Composite)table, this.getAllClassifiersAsString());
        editors[1].setStyle(4);
        editors[2] = new TextCellEditor((Composite)table);
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new AttributeModifier();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElements) {
                return CDAttributeTableEditor.this.getTClass().getAttributes().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object obj, Object newObj) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new AttributeLabelProvider();
    }

    public void updateClassifiers() {
        ((ComboBoxCellEditor)this.getCellEditors()[1]).setItems(this.getAllClassifiersAsString());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    class AttributeModifier
    implements ICellModifier {
        AttributeModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            TAttribute attribute = (TAttribute)element;
            if (property.equals(CDAttributeTableEditor.this.getColumnNames()[0])) {
                String key = attribute.getVisibilityKind().toString();
                return new Integer(this.getSelectionIndex(key, CDAttributeTableEditor.this.VISIBILITIES));
            }
            if (property.equals(CDAttributeTableEditor.this.getColumnNames()[1])) {
                String key = attribute.getType().getName();
                return new Integer(this.getSelectionIndex(key, CDAttributeTableEditor.this.getAllClassifiersAsString()));
            }
            if (property.equals(CDAttributeTableEditor.this.getColumnNames()[2])) {
                return attribute.getName();
            }
            return null;
        }

        private int getSelectionIndex(String key, String[] from) {
            int i = 0;
            while (i < from.length) {
                if (from[i].equals(key)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void modify(Object element, String property, Object value) {
            TAttribute attribute = (TAttribute)((TableItem)element).getData();
            if (property.equals(CDAttributeTableEditor.this.getColumnNames()[0])) {
                int index = Integer.parseInt(String.valueOf(value));
                String selectedKind = CDAttributeTableEditor.this.VISIBILITIES[index];
                TVisibilityKind visibilityKind = TVisibilityKind.getVisibilityKind(selectedKind);
                CDAttributeTableEditor.this.parent.modifyElementVisibility(attribute, visibilityKind);
            } else if (property.equals(CDAttributeTableEditor.this.getColumnNames()[1])) {
                String classifierName = (String)value;
                TClassifier classifier = CDAttributeTableEditor.this.getClassifier(classifierName);
                if (classifier == null) {
                    return;
                }
                CDAttributeTableEditor.this.parent.modifyElementType(attribute, classifier);
            } else if (property.equals(CDAttributeTableEditor.this.getColumnNames()[2])) {
                String name = (String)value;
                CDAttributeTableEditor.this.parent.modifyElementName(attribute, name);
            }
            CDAttributeTableEditor.this.getTableViewer().update((Object)attribute, null);
        }
    }

    class AttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AttributeLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            TAttribute attribute = (TAttribute)element;
            switch (index) {
                case 0: {
                    return attribute.getVisibilityKind().toString();
                }
                case 1: {
                    return attribute.getType().getName();
                }
                case 2: {
                    return attribute.getName();
                }
            }
            return null;
        }

        public Image getColumnImage(Object elemnt, int index) {
            return null;
        }
    }
}

