/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import trier.classdiagram.edit.property.CDMethodTableEditorComposite;
import trier.classdiagram.edit.property.CDModelElementTableEditor;
import trier.classdiagram.edit.property.CDModelElementTableEditorComposite;
import trier.classdiagram.edit.property.ComboTextBoxCellEditor;
import trier.model.core.TClass;
import trier.model.core.TClassifier;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TMethod;
import trier.model.core.TModelElement;
import trier.model.core.TParameter;
import trier.model.core.TVisibilityKind;

public class CDMethodTableEditor
extends CDModelElementTableEditor {
    private final String[] COLUMN_NAMES = new String[]{"Visibility", "Type", "Name", "Parameters"};
    private CDMethodTableEditorComposite parent;

    public CDMethodTableEditor(CDMethodTableEditorComposite parent, TElement element) {
        super(parent, element);
        this.parent = parent;
    }

    protected String[] getColumnNames() {
        return this.COLUMN_NAMES;
    }

    protected Object getElements() {
        return this.getTClass().getMethods();
    }

    private TClass getTClass() {
        return (TClass)this.getModelElement();
    }

    protected int[] getColumnWidth() {
        return new int[]{70, 80, 80, 160};
    }

    protected CellEditor[] getCellEditors() {
        Table table = this.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.COLUMN_NAMES.length];
        editors[0] = new ComboBoxCellEditor((Composite)table, this.VISIBILITIES);
        editors[1] = new ComboTextBoxCellEditor((Composite)table, this.getAllClassifiersAsString());
        editors[2] = new TextCellEditor((Composite)table);
        editors[3] = new TextCellEditor((Composite)table);
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new MethodModifier();
    }

    public String[] getAllClassifiersAsString() {
        List classList = this.getAllClassifiers();
        String[] classes = new String[classList.size() + 1];
        classes[0] = "void";
        int i = 1;
        while (i < classList.size() + 1) {
            TModelElement element = (TModelElement)classList.get(i - 1);
            classes[i] = element.getName();
            ++i;
        }
        return classes;
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElements) {
                return CDMethodTableEditor.this.getTClass().getMethods().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object obj, Object newObj) {
            }
        };
    }

    public TMethod[] getSelectedMethods() {
        Table table = this.getTableViewer().getTable();
        TableItem[] selectedItem = table.getSelection();
        TMethod[] selectedMethods = new TMethod[selectedItem.length];
        int i = 0;
        while (i < selectedItem.length) {
            selectedMethods[i] = (TMethod)selectedItem[i].getData();
            ++i;
        }
        return selectedMethods;
    }

    public int getSelectionIndex() {
        return this.getTableViewer().getTable().getSelectionIndex();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new MethodLabelProvider();
    }

    private String getParametersAsString(List list) {
        StringBuffer parameters = new StringBuffer();
        parameters.append("(");
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                parameters.append(", ");
            }
            TParameter parameter = (TParameter)list.get(i);
            String parameterType = parameter.getType().getName();
            String parameterName = parameter.getName();
            parameters.append(String.valueOf(parameterType) + " " + parameterName);
            ++i;
        }
        parameters.append(")");
        return parameters.toString();
    }

    private String getReturnValueAsString(TClassifier type) {
        if (type.isNull()) {
            return "void";
        }
        return type.getName();
    }

    protected TModelElement getNullObject() {
        TDocument document = this.parent.getTDocument();
        return document.getModelCore().getTDataTypeClass().getNullObject();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    class MethodModifier
    implements ICellModifier {
        MethodModifier() {
        }

        public boolean canModify(Object element, String property) {
            return !property.equals(CDMethodTableEditor.this.COLUMN_NAMES[3]);
        }

        public Object getValue(Object element, String property) {
            TMethod method = (TMethod)element;
            if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[0])) {
                String key = method.getVisibilityKind().toString();
                return new Integer(this.getSelectionIndex(key, CDMethodTableEditor.this.VISIBILITIES));
            }
            if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[1])) {
                String key = CDMethodTableEditor.this.getReturnValueAsString(method.getType());
                return new Integer(this.getSelectionIndex(key, CDMethodTableEditor.this.getAllClassifiersAsString()));
            }
            if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[2])) {
                return method.getName();
            }
            if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[3])) {
                return CDMethodTableEditor.this.getParametersAsString(method.getParameters());
            }
            return null;
        }

        private int getSelectionIndex(String key, String[] from) {
            int i = 0;
            while (i < from.length) {
                if (from[i].equals(key)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void modify(Object element, String property, Object value) {
            TMethod method = (TMethod)((TableItem)element).getData();
            if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[0])) {
                int index = Integer.parseInt(String.valueOf(value));
                String selectedKind = CDMethodTableEditor.this.VISIBILITIES[index];
                TVisibilityKind visibilityKind = TVisibilityKind.getVisibilityKind(selectedKind);
                CDMethodTableEditor.this.parent.modifyElementVisibility(method, visibilityKind);
            } else if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[1])) {
                TClassifier classifier;
                String classifierName = (String)value;
                if (classifierName.equals("void")) {
                    classifier = (TClassifier)CDMethodTableEditor.this.getNullObject();
                } else {
                    classifier = CDMethodTableEditor.this.getClassifier(classifierName);
                    if (classifier == null) {
                        return;
                    }
                }
                CDMethodTableEditor.this.parent.modifyElementType(method, classifier);
            } else if (property.equals(CDMethodTableEditor.this.COLUMN_NAMES[2])) {
                String name = (String)value;
                ((CDModelElementTableEditorComposite)CDMethodTableEditor.this.parent).modifyElementName(method, name);
            } else {
                property.equals(CDMethodTableEditor.this.COLUMN_NAMES[3]);
            }
            CDMethodTableEditor.this.getTableViewer().update((Object)method, null);
        }
    }

    class MethodLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MethodLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            TMethod method = (TMethod)element;
            switch (index) {
                case 0: {
                    return method.getVisibilityKind().toString();
                }
                case 1: {
                    return CDMethodTableEditor.this.getReturnValueAsString(method.getType());
                }
                case 2: {
                    return method.getName();
                }
                case 3: {
                    return CDMethodTableEditor.this.getParametersAsString(method.getParameters());
                }
            }
            return null;
        }

        public Image getColumnImage(Object elemnt, int index) {
            return null;
        }
    }
}

