/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import trier.classdiagram.CDConstants;
import trier.classdiagram.edit.property.CDEditDialog;
import trier.classdiagram.edit.property.CDMethodEditDialog;
import trier.classdiagram.edit.property.CDMethodTableEditor;
import trier.classdiagram.edit.property.CDModelElementTableEditor;
import trier.classdiagram.edit.property.CDModelElementTableEditorComposite;
import trier.diagrameditor.edit.property.EModelTableEditor;
import trier.diagrameditor.model.EElement;
import trier.model.command.TCommand;
import trier.model.core.TClass;
import trier.model.core.TElement;
import trier.model.core.TMethod;
import trier.model.core.TModelElement;
import trier.model.core.TParameter;
import trier.model.core.TVisibilityKind;

public class CDMethodTableEditorComposite
extends CDModelElementTableEditorComposite {
    public CDMethodTableEditorComposite(Composite parent, CDEditDialog parentDialog) {
        super(parentDialog);
        this.createComposite(parent, "Methods", true);
    }

    protected EModelTableEditor initializeTableEditor(Composite parent) {
        CDMethodTableEditor tableEditor = new CDMethodTableEditor(this, (TElement)this.getTClass());
        tableEditor.createControl(parent);
        return tableEditor;
    }

    protected void modifyElement() {
        TModelElement[] selectedMethods = ((CDModelElementTableEditor)this.getTableEditor()).getSelectedElements();
        if (selectedMethods.length == 1) {
            String oldSignature = this.getSignature(selectedMethods[0]);
            EElement newEElement = new EElement(selectedMethods[0], null);
            CDMethodEditDialog methodEditDialog = new CDMethodEditDialog(this.getParentDialog(), newEElement);
            int result = methodEditDialog.open();
            if (result == 0) {
                String newSignature = this.getSignature(methodEditDialog.getTMethod());
                if (!newSignature.equals(oldSignature)) {
                    List methods = this.getTClass().getMethods();
                    int count = 0;
                    int i = 0;
                    while (i < methods.size()) {
                        if (this.getSignature((TMethod)methods.get(i)).equals(newSignature)) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count > 1) {
                        this.showSignatureDuplicateDialog(this.getSignature(methodEditDialog.getTMethod()));
                        methodEditDialog.restoreOldMethod();
                    }
                }
                this.getTableEditor().updateTable();
                this.stateChanged();
            }
        }
    }

    public void modifyElementName(TModelElement modifiedElement, String value) {
        String newName = value;
        String oldName = modifiedElement.getName();
        String signature = String.valueOf(newName) + "(";
        if (modifiedElement instanceof TMethod) {
            List parameterList = ((TMethod)modifiedElement).getParameters();
            int i = 0;
            while (i < parameterList.size()) {
                TParameter parameter = (TParameter)parameterList.get(i);
                String type = parameter.getType().getName();
                if (i != 0) {
                    signature = String.valueOf(signature) + ",";
                }
                signature = String.valueOf(signature) + type;
                ++i;
            }
        }
        signature = String.valueOf(signature) + ")";
        if (!newName.equals(oldName) && this.hasSignature(signature)) {
            this.showSignatureDuplicateDialog(newName);
            return;
        }
        TCommand modifyCommand = this.getTCommandFactory().createSetNameCommand(modifiedElement, value);
        this.executeCommand(modifyCommand);
        this.stateChanged();
    }

    protected String getSignature(TModelElement modelElement) {
        TMethod method = (TMethod)modelElement;
        String name = method.getName();
        String parameterString = "(";
        List parameters = method.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            TParameter parameter = (TParameter)parameters.get(i);
            String type = parameter.getType().getName();
            if (i != 0) {
                parameterString = String.valueOf(parameterString) + ",";
            }
            parameterString = String.valueOf(parameterString) + type;
            ++i;
        }
        parameterString = String.valueOf(parameterString) + ")";
        return String.valueOf(name) + parameterString;
    }

    private TClass getTClass() {
        return (TClass)super.getTElement();
    }

    protected TModelElement getDefaultElement() {
        TMethod method = this.getTDocument().createMethod(CDConstants.DEFAULT_METHOD_EXPRESSION);
        this.getTDocument().setVisibility(method, TVisibilityKind.getVisibilityKind("public"));
        return method;
    }
}

