/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import trier.classdiagram.edit.property.CDModelElementTableEditor;
import trier.classdiagram.edit.property.CDParameterTableEditorComposite;
import trier.classdiagram.edit.property.ComboTextBoxCellEditor;
import trier.model.core.TClassifier;
import trier.model.core.TElement;
import trier.model.core.TMethod;
import trier.model.core.TParameter;

public class CDParameterTableEditor
extends CDModelElementTableEditor {
    private final String[] COLUMN_NAMES = new String[]{"Type", "Name"};
    private CDParameterTableEditorComposite parent;

    public CDParameterTableEditor(CDParameterTableEditorComposite parent, TMethod method) {
        super(parent, (TElement)method);
        this.parent = parent;
    }

    protected String[] getColumnNames() {
        return this.COLUMN_NAMES;
    }

    protected int[] getColumnWidth() {
        return new int[]{130, 130};
    }

    protected Object getElements() {
        return this.parent.getTMethod().getParameters();
    }

    protected CellEditor[] getCellEditors() {
        Table table = this.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.COLUMN_NAMES.length];
        editors[0] = new ComboTextBoxCellEditor((Composite)table, this.getAllClassifiersAsString());
        editors[1] = new TextCellEditor((Composite)table);
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new ParameterModifier();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElements) {
                return CDParameterTableEditor.this.parent.getTMethod().getParameters().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object obj, Object newObj) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new ParameterLabelProvider();
    }

    public void updateClassifiers() {
        ((ComboBoxCellEditor)this.getCellEditors()[1]).setItems(this.getAllClassifiersAsString());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    class ParameterModifier
    implements ICellModifier {
        ParameterModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            TParameter parameter = (TParameter)element;
            if (property.equals(CDParameterTableEditor.this.COLUMN_NAMES[0])) {
                String key = parameter.getType().getName();
                return new Integer(this.getSelectionIndex(key, CDParameterTableEditor.this.getAllClassifiersAsString()));
            }
            if (property.equals(CDParameterTableEditor.this.COLUMN_NAMES[1])) {
                return parameter.getName();
            }
            return null;
        }

        private int getSelectionIndex(String key, String[] from) {
            int i = 0;
            while (i < from.length) {
                if (from[i].equals(key)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void modify(Object element, String property, Object value) {
            TParameter parameter = (TParameter)((TableItem)element).getData();
            if (property.equals(CDParameterTableEditor.this.COLUMN_NAMES[0])) {
                String classifierName = (String)value;
                TClassifier classifier = CDParameterTableEditor.this.getClassifier(classifierName);
                if (classifier == null) {
                    return;
                }
                CDParameterTableEditor.this.parent.modifyElementType(parameter, classifier);
            } else if (property.equals(CDParameterTableEditor.this.COLUMN_NAMES[1])) {
                String name = (String)value;
                CDParameterTableEditor.this.parent.modifyElementName(parameter, name);
            }
            CDParameterTableEditor.this.getTableViewer().update((Object)parameter, null);
        }
    }

    class ParameterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ParameterLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            TParameter parameter = (TParameter)element;
            switch (index) {
                case 0: {
                    return parameter.getType().getName();
                }
                case 1: {
                    return parameter.getName();
                }
            }
            return null;
        }

        public Image getColumnImage(Object elemnt, int index) {
            return null;
        }
    }
}

