/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import trier.classdiagram.edit.property.CDEditDialog;
import trier.diagrameditor.edit.property.EEditComposite;
import trier.model.command.TCommand;
import trier.model.core.TModifiedElement;
import trier.model.core.TVisibilityKind;

public class CDVisibilityComposite
extends EEditComposite {
    private Button[] visibilityButton;

    public CDVisibilityComposite(Composite parent, CDEditDialog parentDialog) {
        super(parentDialog);
        Group visibilityGroup = new Group(parent, 0);
        visibilityGroup.setText("Visibility");
        visibilityGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = TVisibilityKind.getAllVisibilityKind().size();
        visibilityGroup.setLayout((Layout)layout);
        List visibilities = TVisibilityKind.getAllVisibilityKind();
        this.visibilityButton = new Button[visibilities.size()];
        int i = 0;
        while (i < visibilities.size()) {
            TVisibilityKind visibility = (TVisibilityKind)visibilities.get(i);
            this.visibilityButton[i] = new Button((Composite)visibilityGroup, 16);
            this.visibilityButton[i].setText(visibility.toString());
            this.visibilityButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CDVisibilityComposite.this.modifyVisibility();
                }
            });
            if (visibility.toString().equals(this.getTModifiedElement().getVisibilityKind().toString())) {
                this.visibilityButton[i].setSelection(true);
            }
            ++i;
        }
    }

    private void modifyVisibility() {
        int i = 0;
        while (i < this.visibilityButton.length) {
            if (this.visibilityButton[i].getSelection()) {
                String visibilityName = this.visibilityButton[i].getText();
                TVisibilityKind visibility = TVisibilityKind.getVisibilityKind(visibilityName);
                TCommand visibilityChangeCommand = this.getTCommandFactory().createSetVisibilityCommand(this.getTModifiedElement(), visibility);
                this.executeCommand(visibilityChangeCommand);
            }
            ++i;
        }
    }

    protected TModifiedElement getTModifiedElement() {
        return (TModifiedElement)((Object)super.getTElement());
    }
}

