/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.editpart;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import trier.classdiagram.edit.property.CDClassEditDialog;
import trier.classdiagram.figure.CDClassFigure;
import trier.classdiagram.model.CDDocument;
import trier.diagrameditor.action.ESetLooksRequest;
import trier.diagrameditor.edit.direct.EAbstractLabelDirectEditManager;
import trier.diagrameditor.editpart.ENodeEditPart;
import trier.diagrameditor.editpart.policy.EComponentEditPolicy;
import trier.diagrameditor.editpart.policy.EContainerXYLayoutEditPolicy;
import trier.diagrameditor.editpart.policy.ELabelDirectEditPolicy;
import trier.diagrameditor.editpart.policy.ENodeEditPolicy;
import trier.diagrameditor.editpart.policy.ENodeHighlightEditPolicy;
import trier.diagrameditor.model.EAbstractDelayEElement;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.EConnectionDelayEElement;
import trier.diagrameditor.model.EElement;
import trier.model.core.TClass;
import trier.model.core.TElement;
import trier.model.core.TGeneralization;
import trier.model.core.TModelElement;

public class CDClassEditPart
extends ENodeEditPart {
    private CDClassDirectEditManager directEditManager = new CDClassDirectEditManager((GraphicalEditPart)this);

    private CDClassFigure getClassFigure() {
        return (CDClassFigure)this.getFigure();
    }

    private TClass getTClass() {
        return (TClass)((EElement)this.getModel()).getTModel();
    }

    protected void installEditPolicies() {
        super.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new EComponentEditPolicy());
        super.installEditPolicy((Object)"GraphicalNodeEditPolciy", (EditPolicy)new CDClassNodeEditPolicy());
        super.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new ENodeHighlightEditPolicy());
        super.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new CDClassDirectEditPolicy());
        super.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new CDClassXYLayoutEditPolicy());
    }

    protected void showDirectEditor() {
        this.directEditManager.show();
    }

    protected void showPropertyEditor() {
        CDClassEditDialog dialog = new CDClassEditDialog(this.getEditDomain(), (EElement)this.getModel());
        dialog.open();
    }

    protected IFigure createFigure() {
        return new CDClassFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.getClassFigure().updateVisual(this.getElement());
    }

    public boolean understandsRequest(Request request) {
        if (request.getType().equals("$set node type") || request.getType().equals("property edit")) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public void performRequest(Request request) {
        if (request.getType().equals("$set node type")) {
            this.setNodeType((ESetLooksRequest)request);
        } else {
            super.performRequest(request);
        }
    }

    protected void setNodeType(ESetLooksRequest request) {
        DNode node = this.getDNode();
        int newType = 0;
        int applyType = request.getLooksType();
        boolean isExclusion = request.isExclusion();
        newType = ((CDDocument)this.getDocument()).calculateNewNodeType(node.getNodeType(), applyType, isExclusion);
        Command command = this.getEditDomain().getDCommandFactory().createSetNodeTypeCommand(this.getDNode(), newType);
        this.getEditDomain().getCommandStack().execute(command);
    }

    class CDClassNodeEditPolicy
    extends ENodeEditPolicy {
        CDClassNodeEditPolicy() {
        }

        protected boolean isSource(String connectionType) {
            return true;
        }

        protected boolean isTarget(String connectionType, TElement sourceElement) {
            if (connectionType.equals("Generalization")) {
                TClass target = CDClassEditPart.this.getTClass();
                TClass source = (TClass)sourceElement;
                if (source.getSubClassesRecursively().contains(target)) {
                    return false;
                }
                Iterator i = source.getReferedGeneralizations().iterator();
                while (i.hasNext()) {
                    TGeneralization generalization = (TGeneralization)i.next();
                    if (!generalization.getChildClasses().contains(source) || !generalization.getParentClass().equals(target)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    class CDClassDirectEditPolicy
    extends ELabelDirectEditPolicy {
        CDClassDirectEditPolicy() {
        }

        protected Label getLabel() {
            return ((CDClassFigure)CDClassEditPart.this.getFigure()).getTitleLabel();
        }
    }

    class CDClassDirectEditManager
    extends EAbstractLabelDirectEditManager {
        public CDClassDirectEditManager(GraphicalEditPart source) {
            super(source);
        }

        protected Label getLabel() {
            return ((CDClassFigure)CDClassEditPart.this.getFigure()).getTitleLabel();
        }
    }

    class CDClassXYLayoutEditPolicy
    extends EContainerXYLayoutEditPolicy {
        CDClassXYLayoutEditPolicy() {
        }

        protected Command createAddNodeCommandImpl(EElement element, Rectangle r) {
            if (!(element instanceof EAbstractDelayEElement)) {
                return null;
            }
            String type = ((EAbstractDelayEElement)element).getElementType();
            if (type.startsWith("SelfAssociation")) {
                return this.createSelfAssociationCommand(element, type);
            }
            return null;
        }

        private Command createSelfAssociationCommand(EElement element, String type) {
            ((EConnectionDelayEElement)element).setSource(CDClassEditPart.this.getDNode());
            ((EConnectionDelayEElement)element).setTarget(CDClassEditPart.this.getDNode());
            ((EConnectionDelayEElement)element).recreateElement(CDClassEditPart.this.getDocument());
            EElement newConnection = element;
            CompoundCommand commands = new CompoundCommand();
            commands.add((Command)new ECommand(this.getDomain().getTCommandFactory().createRelateCommand((TModelElement)CDClassEditPart.this.getDocument().getDiagramOwner(), newConnection.getTModel(), CDClassEditPart.this.getTElement(), CDClassEditPart.this.getTElement())));
            commands.add(this.getDomain().getECommandFactory().createAddEElementCommand(newConnection));
            commands.add(this.getDomain().getDCommandFactory().createAddElementCommand(newConnection.getDModel()));
            commands.add(this.getDomain().getDCommandFactory().createSetConnectionTypeCommand((DConnection)newConnection.getDModel(), 1));
            DRelativePoint[] rp = new DRelativePoint[3];
            int[] flagX = null;
            int[] flagY = null;
            if (type.equals("SelfAssociationTopRight")) {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 1;
                flagX = nArray;
                int[] nArray2 = new int[3];
                nArray2[0] = -1;
                nArray2[1] = -1;
                flagY = nArray2;
            } else if (type.equals("SelfAssociationTopLeft")) {
                int[] nArray = new int[3];
                nArray[1] = -1;
                nArray[2] = -1;
                flagX = nArray;
                int[] nArray3 = new int[3];
                nArray3[0] = -1;
                nArray3[1] = -1;
                flagY = nArray3;
            } else if (type.equals("SelfAssociationBottomRight")) {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 1;
                flagX = nArray;
                int[] nArray4 = new int[3];
                nArray4[0] = 1;
                nArray4[1] = 1;
                flagY = nArray4;
            } else if (type.equals("SelfAssociationBottomLeft")) {
                int[] nArray = new int[3];
                nArray[1] = -1;
                nArray[2] = -1;
                flagX = nArray;
                int[] nArray5 = new int[3];
                nArray5[0] = 1;
                nArray5[1] = 1;
                flagY = nArray5;
            } else {
                throw new RuntimeException("Illegal Element Type");
            }
            Rectangle r = CDClassEditPart.this.getNodeFigure().getBounds();
            int i = 0;
            while (i < rp.length) {
                rp[i] = this.createRelativePoint(r, flagX[i], flagY[i]);
                ++i;
            }
            i = 0;
            while (i < rp.length) {
                commands.add(this.getDomain().getDCommandFactory().createAddBendpointCommand((DConnection)newConnection.getDModel(), rp[i], i));
                ++i;
            }
            return commands;
        }

        private DRelativePoint createRelativePoint(Rectangle r, int flagX, int flagY) {
            Point center = r.getCenter();
            return DRelativePoint.createInstance((Point)center.getTranslated(new Dimension(flagX * (r.width / 2 + 35), flagY * (r.height / 2 + 35))), (Point)center, (Point)center);
        }
    }
}

