/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.figure;

import diagrammodelfw.model.DNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import trier.TrierPlugin;
import trier.diagrameditor.figure.ENodeFigure;
import trier.diagrameditor.model.EElement;
import trier.model.core.TAttribute;
import trier.model.core.TClass;
import trier.model.core.TMethod;

public class CDClassFigure
extends ENodeFigure
implements PropertyChangeListener {
    public static final int HIDE_ATTRIBUTE = 1;
    public static final int HIDE_METHOD = 2;
    public static final int HIDE_STEREO_TYPE = 4;
    public static final int HIDE_ICON = 8;
    private Figure parentLayer = new Figure();
    private Figure titleLayer = new Figure();
    private Figure stereoTypeLayer = new Figure();
    private Figure methodLine = new ClassLine();
    private Figure methodLayer = new Figure();
    private Figure attributeLine = new ClassLine();
    private Figure attributeLayer = new Figure();
    private Label titleLabel = new Label();
    private Label stereoTypeLabel = new Label();
    private EElement eClass;
    public static final int xMargin = 10;
    public static final int yMargin = 10;
    private int layoutCurrentHeight = 0;

    public CDClassFigure() {
        this.initialize();
    }

    protected void initialize() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder(null);
        DelegatingLayout parentLayout = new DelegatingLayout();
        this.parentLayer.setLayoutManager((LayoutManager)parentLayout);
        this.parentLayer.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
        this.add((IFigure)this.parentLayer);
    }

    public void updateVisual(EElement element) {
        this.eClass = element;
        TClass tClass = (TClass)element.getTModel();
        DNode dNode = (DNode)element.getDModel();
        this.parentLayer.removeAll();
        int style = dNode.getNodeType();
        if (!tClass.getStereoType().isNull() && (style & 4) != 4) {
            new DelegatingLayout();
            this.stereoTypeLabel.setText(tClass.getStereoType().toString());
            this.parentLayer.add((IFigure)this.stereoTypeLabel, (Object)new LabelLocator());
        }
        if ((style & 8) != 8) {
            this.titleLabel.setIcon(this.getLabelIcon(tClass));
        } else {
            this.titleLabel.setIcon(null);
        }
        this.titleLabel.setText(tClass.getName());
        this.parentLayer.add((IFigure)this.titleLabel, (Object)new LabelLocator());
        if ((style & 1) != 1) {
            FlowLayout attributeLayout = new FlowLayout(false);
            attributeLayout.setMinorSpacing(0);
            this.attributeLayer.setLayoutManager((LayoutManager)attributeLayout);
            this.updateAttributeText(tClass.getAttributes());
            this.parentLayer.add((IFigure)this.attributeLine, (Object)new LineLocator());
            this.parentLayer.add((IFigure)this.attributeLayer, (Object)new FeatureLabelsLocator());
        }
        if ((style & 2) != 2) {
            FlowLayout methodLayout = new FlowLayout(false);
            methodLayout.setMinorSpacing(0);
            this.methodLayer.setLayoutManager((LayoutManager)methodLayout);
            this.updateMethodText(tClass.getMethods());
            this.parentLayer.add((IFigure)this.methodLine, (Object)new LineLocator());
            this.parentLayer.add((IFigure)this.methodLayer, (Object)new FeatureLabelsLocator());
        }
    }

    private void updateAttributeText(List attributes) {
        this.attributeLayer.removeAll();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            TAttribute attribute = (TAttribute)i.next();
            this.attributeLayer.add((IFigure)new Label(attribute.toString()));
        }
    }

    private void updateMethodText(List methods) {
        this.methodLayer.removeAll();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            TMethod method = (TMethod)i.next();
            this.methodLayer.add((IFigure)new Label(method.toString()));
        }
    }

    public Image getLabelIcon(TClass clazz) {
        if (clazz.isInterface()) {
            return TrierPlugin.getDefault().getBannerImg("class/interface16.gif").createImage();
        }
        return TrierPlugin.getDefault().getBannerImg("class/class16.gif").createImage();
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.parentLayer.setBounds(r);
        this.layoutCurrentHeight = 0;
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
        g.setBackgroundColor(TrierPlugin.DEFAULT_CLASS_FILL_COLOR);
        g.setLineWidth(1);
        Rectangle r = super.getBounds();
        r = this.getBoundsForDraw(1);
        g.fillRectangle(r);
        g.drawRectangle(r);
    }

    private int layoutGetWidth() {
        Rectangle r = this.getBounds();
        return r.width;
    }

    private int layoutGetHeight() {
        Rectangle r = this.getBounds();
        return r.height;
    }

    private Point layoutGetLocation() {
        Rectangle r = this.getBounds();
        int x = r.x + 10;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    private Point layoutGetLocationNoMargin() {
        Rectangle r = this.getBounds();
        int x = r.x;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateVisual(this.eClass);
    }

    public static void main(String[] args) {
    }

    class LabelLocator
    implements Locator {
        LabelLocator() {
        }

        public void relocate(IFigure target) {
            CDClassFigure cDClassFigure = CDClassFigure.this;
            cDClassFigure.layoutCurrentHeight = cDClassFigure.layoutCurrentHeight + 10;
            int width = CDClassFigure.this.layoutGetWidth() - 20;
            int height = target.getPreferredSize().height;
            target.setBounds(new Rectangle(CDClassFigure.this.layoutGetLocation(), new Dimension(width, height)));
            CDClassFigure cDClassFigure2 = CDClassFigure.this;
            cDClassFigure2.layoutCurrentHeight = cDClassFigure2.layoutCurrentHeight + height;
        }
    }

    class LineLocator
    implements Locator {
        LineLocator() {
        }

        public void relocate(IFigure target) {
            int width = CDClassFigure.this.layoutGetWidth();
            int height = 20;
            target.setBounds(new Rectangle(CDClassFigure.this.layoutGetLocationNoMargin(), new Dimension(width, height)));
            CDClassFigure cDClassFigure = CDClassFigure.this;
            cDClassFigure.layoutCurrentHeight = cDClassFigure.layoutCurrentHeight + height;
        }
    }

    class FeatureLabelsLocator
    implements Locator {
        FeatureLabelsLocator() {
        }

        public void relocate(IFigure target) {
            int width = CDClassFigure.this.layoutGetWidth() - 20;
            int height = target.getPreferredSize().height;
            target.setBounds(new Rectangle(CDClassFigure.this.layoutGetLocation(), new Dimension(width, height)));
            CDClassFigure cDClassFigure = CDClassFigure.this;
            cDClassFigure.layoutCurrentHeight = cDClassFigure.layoutCurrentHeight + height;
        }
    }

    class ClassLine
    extends Figure {
        ClassLine() {
        }

        protected void paintFigure(Graphics g) {
            super.paintFigure(g);
            Polyline line = new Polyline();
            line.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
            line.setLineWidth(1);
            Rectangle r = super.getBounds();
            int y = r.getCenter().y;
            int left = r.getLeft().x;
            int right = r.getRight().x;
            line.setStart(new Point(left, y));
            line.setEnd(new Point(right, y));
            line.paint(g);
        }
    }
}

