/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.figure;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import trier.TrierPlugin;
import trier.diagrameditor.figure.ENodeFigure;
import trier.model.core.TPackage;

public class CDPackageFigure
extends ENodeFigure {
    private Figure titleLayer = new Figure();
    private Label titleLabel = new Label();
    public static final int xMargin = 10;
    public static final int yMargin = 10;
    private int layoutCurrentHeight = 0;

    public CDPackageFigure() {
        this.initialize();
        this.initializeComponents();
    }

    protected void initialize() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder(null);
    }

    protected void initializeComponents() {
        DelegatingLayout titleLayout = new DelegatingLayout();
        this.titleLayer.setLayoutManager((LayoutManager)titleLayout);
        this.titleLayer.setForegroundColor(TrierPlugin.DEFAULT_NOTE_PEN_COLOR);
        this.add((IFigure)this.titleLayer);
        this.titleLayer.add((IFigure)this.titleLabel, (Object)new TitleLabelLocator());
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void updateVisual(TPackage tPackage) {
        this.titleLabel.setText(tPackage.getName());
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.titleLayer.setBounds(r);
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (index == -1) {
            super.add(figure, constraint, index);
        } else if (figure == this.titleLayer) {
            super.add(figure, constraint, 0);
        } else {
            super.add(figure, constraint, index + 1);
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
        g.setBackgroundColor(TrierPlugin.DEFAULT_CLASS_FILL_COLOR);
        g.setLineWidth(1);
        Rectangle r = super.getBounds();
        r = this.getBoundsForDraw(1);
        this.drawPackage(g, r);
    }

    private void drawPackage(Graphics g, Rectangle r) {
        g.fillRectangle(r);
        int tagHight = 10;
        int tagWidth = 20;
        g.drawLine(r.x, r.y + tagHight, r.right(), r.y + tagHight);
        g.drawLine(r.x, r.y + tagHight, r.x, r.bottom());
        g.drawLine(r.getBottomLeft(), r.getBottomRight());
        g.drawLine(r.right(), r.y + tagHight, r.right(), r.bottom());
        g.drawLine(r.x, r.y, r.x, r.y + tagHight);
        g.drawLine(r.x, r.y, r.x + tagWidth, r.y);
        g.drawLine(r.x + tagWidth, r.y, r.x + tagWidth, r.y + tagHight);
        g.drawLine(r.x, r.y + tagHight, r.x + tagWidth, r.y + tagHight);
    }

    private int layoutGetWidth() {
        Rectangle r = this.getBounds();
        return r.width;
    }

    private int layoutGetHeight() {
        Rectangle r = this.getBounds();
        return r.height;
    }

    private Point layoutGetLocation() {
        Rectangle r = this.getBounds();
        int x = r.x + 10;
        int y = r.y + this.layoutCurrentHeight + 10;
        return new Point(x, y);
    }

    private Point layoutGetLocationNoMargin() {
        Rectangle r = this.getBounds();
        int x = r.x;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    class TitleLabelLocator
    implements Locator {
        TitleLabelLocator() {
        }

        public void relocate(IFigure target) {
            CDPackageFigure.this.layoutCurrentHeight = 10;
            int width = CDPackageFigure.this.layoutGetWidth() - 20;
            int height = target.getPreferredSize().height;
            target.setBounds(new Rectangle(CDPackageFigure.this.layoutGetLocation(), new Dimension(width, height)));
            CDPackageFigure cDPackageFigure = CDPackageFigure.this;
            cDPackageFigure.layoutCurrentHeight = cDPackageFigure.layoutCurrentHeight + height;
        }
    }
}

