/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ECreateFileWizardPage
extends WizardNewFileCreationPage {
    private Text containerText;
    private Text fileText;
    private static int count = 1;
    private String exampleName;
    private String extension;

    public ECreateFileWizardPage(IStructuredSelection selection, String exampleName, String extension) {
        super("Hoge", selection);
        this.exampleName = exampleName;
        this.extension = extension;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        super.setFileName(String.valueOf(this.exampleName) + count);
        Composite cfr_ignored_0 = (Composite)this.getControl();
        super.setPageComplete(this.validatePage());
    }

    public boolean finish() {
        String fileName = this.getFileName();
        if (!fileName.endsWith(this.extension)) {
            super.setFileName(String.valueOf(fileName) + this.extension);
        }
        boolean retValue = super.validatePage();
        final IFile file = this.createNewFile();
        if (retValue && file != null) {
            Shell shell = this.getShell();
            IWorkbenchPage page = JavaPlugin.getActivePage();
            if (shell == null || page == null) {
                ++count;
                return true;
            }
            final IWorkbenchPart focusPart = page.getActivePart();
            if (focusPart instanceof ISetSelectionTarget) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                });
            }
            try {
                page.openEditor(file);
                ++count;
                return true;
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)((Object)e), (Shell)shell, (String)NewWizardMessages.getString((String)"NewSnippetFileWizardPage.open_error.message"), (String)e.getMessage());
            }
        }
        return false;
    }

    protected boolean validatePage() {
        String fileName;
        boolean valid = super.validatePage();
        if (!valid) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = JavaPlugin.getWorkspace().getRoot();
        IPath containerPath = this.getContainerFullPath();
        if (containerPath != null && containerPath.segmentCount() > 0) {
            IProject project = workspaceRoot.getProject(containerPath.segment(0));
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.setErrorMessage(NewWizardMessages.getString((String)"NewSnippetFileWizardPage.error.OnlyInJavaProject"));
                    return false;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log((IStatus)e.getStatus());
            }
        }
        if ((fileName = this.getFileName()) != null && !fileName.endsWith(this.extension)) {
            fileName = String.valueOf(fileName) + this.extension;
            IPath path = this.getContainerFullPath();
            if (path != null && workspaceRoot.exists(path.append(fileName))) {
                this.setErrorMessage(NewWizardMessages.getString((String)"NewSnippetFileWizardPage.error.AlreadyExists"));
                return false;
            }
        }
        return true;
    }
}

