/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor;

import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import trier.diagrameditor.EEditor;

public class EKeyHandlerFactory {
    private EEditor editor;

    public static KeyHandler createKeyHandler(EEditor editor) {
        EKeyHandlerFactory instance = new EKeyHandlerFactory(editor);
        return instance.createKeyHandler();
    }

    protected EKeyHandlerFactory(EEditor editor) {
        this.editor = editor;
    }

    protected KeyHandler createKeyHandler() {
        KeyHandler sharedKeyHandler = new KeyHandler();
        sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.editor.getActionRegistry().getAction((Object)"delete"));
        sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.editor.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        this.installStepMoveHandler(sharedKeyHandler);
        return sharedKeyHandler;
    }

    protected void installStepMoveHandler(KeyHandler sharedKeyHandler) {
        sharedKeyHandler.put(KeyStroke.getPressed((int)0x1000004, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove right"));
        sharedKeyHandler.put(KeyStroke.getPressed((int)0x1000003, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove left"));
        sharedKeyHandler.put(KeyStroke.getPressed((int)0x1000001, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove up"));
        sharedKeyHandler.put(KeyStroke.getPressed((int)0x1000002, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove down"));
        this.installExportSVGHandler(sharedKeyHandler);
    }

    protected void installExportSVGHandler(KeyHandler sharedKeyHandler) {
        sharedKeyHandler.put(KeyStroke.getPressed((char)'s', (int)0), this.editor.getActionRegistry().getAction((Object)"$export svg"));
    }

    protected EEditor getEditor() {
        return this.editor;
    }
}

