/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import trier.TrierPlugin;
import trier.diagrameditor.EConnectionCreationFactory;
import trier.diagrameditor.ENodeCreationFactory;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EEditDomain;

public abstract class EPaletteFactory {
    private EEditDomain domain = null;

    protected EPaletteFactory(EEditDomain domain) {
        this.domain = domain;
    }

    protected EDocument getEDocument() {
        return this.domain.getDocument();
    }

    protected PaletteRoot createPalette() {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.addAll(this.createCategories(paletteRoot));
        return paletteRoot;
    }

    protected abstract List createCategories(PaletteRoot var1);

    protected PaletteContainer createControlCategory(PaletteRoot root) {
        PaletteGroup category = new PaletteGroup("Control");
        ArrayList<SelectionToolEntry> entries = new ArrayList<SelectionToolEntry>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        entries.add(tool);
        category.addAll(entries);
        return category;
    }

    protected PaletteContainer createNoteCategory() {
        PaletteDrawer category = new PaletteDrawer("Note");
        ArrayList<Object> entries = new ArrayList<Object>();
        CreationToolEntry noteCreationTool = new CreationToolEntry("Note", "create note", (CreationFactory)new ENodeCreationFactory("Note", this.getEDocument()), TrierPlugin.getDefault().getBannerImg("class/note16.gif"), TrierPlugin.getDefault().getBannerImg("class/note16.gif"));
        entries.add(noteCreationTool);
        ConnectionCreationToolEntry anchorCreationTool = new ConnectionCreationToolEntry("Anchor", "relate anchor", (CreationFactory)new EConnectionCreationFactory("Anchor", this.getEDocument()), TrierPlugin.getDefault().getBannerImg("class/anchor16.gif"), TrierPlugin.getDefault().getBannerImg("class/anchor16.gif"));
        entries.add(anchorCreationTool);
        category.addAll(entries);
        return category;
    }
}

