/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.action;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import trier.TrierPlugin;
import trier.diagrameditor.EEditor;
import trier.diagrameditor.model.EElement;
import trier.model.core.TElement;

public class EDeleteModelAction
extends SelectionAction {
    private static final Logger logger;
    public static final String ID = "delete model";
    public static final String REQ_DELETE_MODEL = "$delete model";
    public static final String DISPLAY_TEXT = "Delete Model";
    public static final String TOOLTIP_TEXT = "Delete Model";
    private Request deleteModelRequest = new Request((Object)"$delete model");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.action.EDeleteModelAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public EDeleteModelAction(IWorkbenchPart part) {
        super(part);
    }

    protected boolean calculateEnabled() {
        Iterator i = this.getSelectedObjects().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof EditPart)) {
                return false;
            }
            if (((EditPart)o).understandsRequest(this.getDeleteModelRequest())) continue;
            return false;
        }
        return true;
    }

    protected Request getDeleteModelRequest() {
        return this.deleteModelRequest;
    }

    public void run() {
        try {
            IEditorReference[] editors = TrierPlugin.getDefault().getActivePage().getEditorReferences();
            CompoundCommand commands = new CompoundCommand();
            int i = 0;
            while (i < editors.length) {
                IEditorPart editorPart = editors[i].getEditor(false);
                if (editorPart instanceof EEditor) {
                    EEditor cdEditor = (EEditor)editorPart;
                    Iterator iterator = this.getSelectedObjects().iterator();
                    while (iterator.hasNext()) {
                        EditPart part = (EditPart)iterator.next();
                        EElement eElement = null;
                        eElement = part.getModel() instanceof EElement ? (EElement)part.getModel() : new EElement((TElement)part.getModel(), null);
                        if (cdEditor.getEEditDomain().getDocument().getElementsByTElement(eElement.getTModel()).isEmpty()) continue;
                        Command command = cdEditor.getEEditDomain().createRemoveEElementFromModelCommand(eElement.getTModel());
                        commands.add(command);
                    }
                }
                ++i;
            }
            if (!commands.isEmpty()) {
                this.getCommandStack().execute((Command)commands);
            } else {
                IWorkbenchPage page = TrierPlugin.getDefault().getActivePage();
                EEditor editor = (EEditor)page.getActiveEditor();
                Iterator iterator = this.getSelectedObjects().iterator();
                while (iterator.hasNext()) {
                    EditPart part = (EditPart)iterator.next();
                    EElement eElement = new EElement((TElement)part.getModel(), null);
                    Command command = editor.getEEditDomain().createRemoveEElementFromModelCommand(eElement.getTModel());
                    commands.add(command);
                }
                this.getCommandStack().execute((Command)commands);
            }
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Delete Model Failed", (Throwable)e);
            Display.getCurrent().beep();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Display.getCurrent().beep();
        }
    }

    public void setDeleteModelRequest(Request req) {
        this.deleteModelRequest = req;
    }

    protected void init() {
        super.init();
        this.setText("Delete Model");
        this.setToolTipText("Delete Model");
        this.setId(ID);
    }
}

