/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.action;

import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import trier.diagrameditor.action.ESetLooksRequest;

public class ESetLineTypeAction
extends SelectionAction {
    public static final String MANHATTAN_ID = "Manhattan";
    public static final String NORMAL_ID = "Normal";
    public static final String REQ_LINE_TYPE = "$set line type";
    public static final String TOOLTIP_TEXT = "Edit Line Type";
    private ESetLooksRequest setLineTypeRequest;

    public ESetLineTypeAction(IWorkbenchPart part, int type) {
        super(part);
        this.setLineTypeRequest = new ESetLooksRequest(REQ_LINE_TYPE, type);
        this.setLineType();
    }

    protected boolean calculateEnabled() {
        Iterator i = this.getSelectedObjects().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof EditPart)) {
                return false;
            }
            if (((EditPart)o).understandsRequest(this.getSetLineTypeRequest())) continue;
            return false;
        }
        return true;
    }

    protected Request getSetLineTypeRequest() {
        return this.setLineTypeRequest;
    }

    public void run() {
        try {
            Iterator i = this.getSelectedObjects().iterator();
            while (i.hasNext()) {
                EditPart part = (EditPart)i.next();
                part.performRequest(this.getSetLineTypeRequest());
            }
        }
        catch (ClassCastException classCastException) {
            Display.getCurrent().beep();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Display.getCurrent().beep();
        }
    }

    protected void init() {
        super.init();
        this.setToolTipText(TOOLTIP_TEXT);
    }

    private void setLineType() {
        if (this.setLineTypeRequest.getLooksType() == 1) {
            this.setId(NORMAL_ID);
        } else {
            this.setId(MANHATTAN_ID);
        }
        this.setText(this.getId());
    }
}

