/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.edit.property;

import diagrammodelfw.model.DConnection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;

public class EDocumentEditDialog
extends EEditDialog {
    public static final int LABEL_WIDTH = 200;
    public static final int BUTTON_WIDTH = 100;
    public static final int COMBO_WIDTH = 250;
    private static final String[] CONNECTION_TYPES = new String[]{"Normal", "Manhattan"};
    private static final Logger logger;
    private Combo lineTypeCombo;
    private Button lineApplyAllButton;
    private Group looksGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.edit.property.EDocumentEditDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public EDocumentEditDialog(EEditDomain domain, EElement element) {
        super(domain, element);
    }

    protected Control createDialogArea(Composite parent) {
        Shell mainShell = parent.getShell();
        mainShell.setText("Diagram Setting");
        parent.setLayout((Layout)new GridLayout(1, false));
        this.initializeLineLooksGroup(parent);
        return parent;
    }

    protected void initializeLineLooksGroup(Composite parent) {
        this.looksGroup = new Group(parent, 0);
        this.looksGroup.setText("Default Line Looks");
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.looksGroup.setLayout((Layout)layout);
        this.looksGroup.setLayoutData((Object)new GridData(768));
        this.initializeLineLooksCompoiste((Composite)this.looksGroup);
    }

    private void initializeLineLooksCompoiste(Composite parent) {
        Composite lineLooksComposite = new Composite(parent, 0);
        lineLooksComposite.setLayout((Layout)new GridLayout(3, false));
        lineLooksComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(lineLooksComposite, 0);
        label.setText("Line Type");
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        this.lineTypeCombo = new Combo(lineLooksComposite, 8);
        this.lineTypeCombo.add(CONNECTION_TYPES[0]);
        this.lineTypeCombo.add(CONNECTION_TYPES[1]);
        this.lineTypeCombo.select(this.getDDocument().getConnectionType() - 1);
        GridData comboGridData = new GridData(768);
        comboGridData.widthHint = 250;
        this.lineTypeCombo.setLayoutData((Object)comboGridData);
        this.lineTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EDocumentEditDialog.this.lineTypeComboSeletcted(e);
            }
        });
        this.lineApplyAllButton = new Button(lineLooksComposite, 8);
        this.lineApplyAllButton.setText("Apply All");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lineApplyAllButton.setLayoutData((Object)gridData);
        this.lineApplyAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EDocumentEditDialog.this.lineApplyAllSeletcted(e);
            }
        });
    }

    protected Group getLooksGroup() {
        return this.looksGroup;
    }

    protected void lineTypeComboSeletcted(SelectionEvent e) {
        int type = this.getSelectedLineType();
        Command command = this.getEEditDomain().getDCommandFactory().createSetDefaultConnectionTypeCommand(type);
        super.executeCommand(command);
    }

    protected void lineApplyAllSeletcted(SelectionEvent e) {
        if (this.getDDocument().getAllNodes().isEmpty()) {
            return;
        }
        int type = this.getSelectedLineType();
        CompoundCommand commands = new CompoundCommand();
        Iterator i = this.getDDocument().getAllConnections().iterator();
        while (i.hasNext()) {
            DConnection connection = (DConnection)i.next();
            commands.add(this.getEEditDomain().getDCommandFactory().createSetConnectionTypeCommand(connection, type));
        }
        super.executeCommand((Command)commands);
    }

    private int getSelectedLineType() {
        return this.lineTypeCombo.getSelectionIndex() + 1;
    }
}

