/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.edit.property;

import diagrammodelfw.command.DCommandFactory;
import diagrammodelfw.model.DDocument;
import diagrammodelfw.model.DElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.Dialog;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;
import trier.model.command.TCommand;
import trier.model.command.TCommandFactory;
import trier.model.core.TDocument;
import trier.model.core.TElement;

public abstract class EEditDialog
extends Dialog {
    private EEditDomain domain;
    private EElement model;
    private CommandStack commandStack = new CommandStack();
    private CommandStack parentCommandStack;

    public EEditDialog(EEditDomain domain, EElement element) {
        super(domain.getEditorPart().getSite().getShell());
        this.domain = domain;
        this.parentCommandStack = domain.getCommandStack();
        this.model = element;
    }

    public EEditDialog(EEditDialog parentDialog, EElement element) {
        super(parentDialog.domain.getEditorPart().getSite().getShell());
        this.domain = parentDialog.domain;
        this.parentCommandStack = parentDialog.commandStack;
        this.model = element;
    }

    public EEditDomain getEEditDomain() {
        return this.domain;
    }

    public EDocument getEDocument() {
        return this.getEEditDomain().getDocument();
    }

    public TDocument getTDocument() {
        return this.getEEditDomain().getDocument().getTDocument();
    }

    public DDocument getDDocument() {
        return this.getEEditDomain().getDocument().getDDocument();
    }

    public TCommandFactory getTCommandFactory() {
        return this.getEEditDomain().getTCommandFactory();
    }

    public DCommandFactory getDCommandFactory() {
        return this.getEEditDomain().getDCommandFactory();
    }

    public EElement getEModel() {
        return this.model;
    }

    public TElement getTModel() {
        return this.model.getTModel();
    }

    public DElement getDModel() {
        return this.model.getDModel();
    }

    protected void executeCommand(Command command) {
        this.commandStack.execute(command);
    }

    protected void executeCommand(TCommand command) {
        this.executeCommand(new ECommand(command));
    }

    protected void okPressed() {
        EDialogCommand command = new EDialogCommand(this.commandStack.getCommands());
        if (command.hasExecutedCommand()) {
            this.parentCommandStack.execute((Command)command);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        EDialogCommand command = new EDialogCommand(this.commandStack.getCommands());
        if (command.hasExecutedCommand()) {
            command.undo();
        }
        super.cancelPressed();
    }

    class EDialogCommand
    extends Command {
        private CompoundCommand executedCommands = new CompoundCommand("dialog command");

        public EDialogCommand(Object[] objects) {
            int i = 0;
            while (i < objects.length) {
                this.executedCommands.add((Command)objects[i]);
                ++i;
            }
        }

        public boolean hasExecutedCommand() {
            return this.executedCommands.size() > 0;
        }

        public void execute() {
        }

        public void undo() {
            this.executedCommands.undo();
        }

        public void redo() {
            this.executedCommands.redo();
        }
    }
}

