/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.edit.property;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import trier.diagrameditor.edit.property.EEditComposite;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.edit.property.EModelTableEditor;
import trier.model.core.TModelElement;

public abstract class EModelEditTableComposite
extends EEditComposite {
    private static final int MODIFY = 50;
    private EModelTableEditor tableEditor;
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            EModelEditTableComposite.this.buttonSelected(e);
        }
    };
    private Button addButton;
    private Button modifyButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;

    public EModelEditTableComposite(EEditDialog parentDialog) {
        super(parentDialog);
    }

    protected void createComposite(Composite parent, String groupTitle, boolean modify) {
        Group group = new Group(parent, 0);
        group.setText(groupTitle);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 120;
        group.setLayoutData((Object)gridData);
        this.tableEditor = this.initializeTableEditor((Composite)group);
        this.initializeMoveButton((Composite)group);
        this.initializeEditButtons((Composite)group, modify);
    }

    private void initializeEditButtons(Composite methodGroup, boolean modify) {
        Composite buttonComposite = new Composite(methodGroup, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        buttonComposite.setLayoutData((Object)new GridData(128));
        this.addButton = new Button(buttonComposite, 2048);
        this.addButton.setText("add");
        this.addButton.addSelectionListener((SelectionListener)this.selectionAdapter);
        if (modify) {
            this.modifyButton = new Button(buttonComposite, 2048);
            this.modifyButton.setText("modify");
            this.modifyButton.addSelectionListener((SelectionListener)this.selectionAdapter);
            this.modifyButton.setEnabled(false);
        }
        this.removeButton = new Button(buttonComposite, 2048);
        this.removeButton.setText("remove");
        this.removeButton.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.removeButton.setEnabled(false);
    }

    private void initializeMoveButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.upButton = new Button(composite, 0x800084);
        this.upButton.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.upButton.setEnabled(false);
        Label space = new Label(composite, 0);
        space.setLayoutData((Object)new GridData(1040));
        this.downButton = new Button(composite, 0x800404);
        this.downButton.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.downButton.setEnabled(false);
    }

    protected boolean lastElementSelected() {
        int[] selectedIndices = this.getTable().getSelectionIndices();
        return selectedIndices.length <= 0 || selectedIndices[selectedIndices.length - 1] == this.getTable().getItemCount() - 1;
    }

    protected boolean hasSignature(String signature) {
        List list = (List)this.tableEditor.getElements();
        int i = 0;
        while (i < list.size()) {
            TModelElement element = (TModelElement)list.get(i);
            if (signature.equals(this.getSignature(element))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getUniqueSignatureName(TModelElement element) {
        String uniqueSignature;
        int uniqueID = 0;
        while (this.hasSignature(uniqueSignature = String.valueOf(this.getSignature(element)) + ++uniqueID)) {
        }
        return String.valueOf(element.getName()) + uniqueID;
    }

    protected int showSignatureDuplicateDialog(String signature) {
        MessageBox box = new MessageBox(this.getParentDialog().getShell(), 1);
        box.setText("Signature Duplicated");
        box.setMessage(signature);
        return box.open();
    }

    private void buttonSelected(SelectionEvent event) {
        Button selectedButton = (Button)event.widget;
        if (selectedButton.equals(this.addButton)) {
            this.addNewElement();
        } else if (selectedButton.equals(this.modifyButton)) {
            this.modifyElement();
        } else if (selectedButton.equals(this.removeButton)) {
            this.removeElement();
        } else if (selectedButton.equals(this.upButton)) {
            this.moveUpElements();
        } else if (selectedButton.equals(this.downButton)) {
            this.moveDownElements();
        }
        this.changeButtonState();
    }

    protected void changeButtonState() {
        int selectionCount = this.getTable().getSelectionCount();
        if (selectionCount <= 0) {
            this.removeButton.setEnabled(false);
            if (this.modifyButton != null) {
                this.modifyButton.setEnabled(false);
            }
            this.addButton.setEnabled(true);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            if (this.modifyButton != null) {
                this.modifyButton.setEnabled(true);
            }
            this.addButton.setEnabled(true);
            int[] indices = this.getTable().getSelectionIndices();
            if (indices[0] == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            int rawMaxIndex = this.getTable().getItemCount() - 1;
            int selectionLastIndex = indices[indices.length - 1];
            if (rawMaxIndex == selectionLastIndex) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        }
        if (selectionCount > 1) {
            this.addButton.setEnabled(false);
            if (this.modifyButton != null) {
                this.modifyButton.setEnabled(false);
            }
        }
    }

    protected abstract EModelTableEditor initializeTableEditor(Composite var1);

    protected abstract String getSignature(TModelElement var1);

    protected abstract TModelElement getDefaultElement();

    protected abstract void addNewElement();

    protected abstract void modifyElement();

    protected abstract void removeElement();

    protected abstract void moveUpElements();

    protected abstract void moveDownElements();

    protected EModelTableEditor getTableEditor() {
        return this.tableEditor;
    }

    protected Table getTable() {
        return this.tableEditor.getTableViewer().getTable();
    }
}

