/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.edit.property;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import trier.diagrameditor.edit.property.EModelEditTableComposite;
import trier.model.core.TElement;
import trier.model.core.TVisibilityKind;

public abstract class EModelTableEditor {
    private EModelEditTableComposite tableEditorComposite;
    private TableViewer tableViewer;
    protected final String[] VISIBILITIES = (String[])TVisibilityKind.getAllVisibilityKindAsString().toArray();
    private TElement element;

    public EModelTableEditor(EModelEditTableComposite composite, TElement element) {
        this.tableEditorComposite = composite;
        this.element = element;
    }

    public void createControl(Composite parent) {
        this.initializeTable(parent, 67586);
        this.initializeTableHeader();
        this.initializeTableItem();
        this.tableViewer.refresh(true);
    }

    private void initializeTable(Composite composite, int style) {
        this.tableViewer = new TableViewer(composite, style);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.getColumnNames());
        this.tableViewer.setCellEditors(this.getCellEditors());
        this.tableViewer.setCellModifier(this.getCellModifiers());
        this.tableViewer.setContentProvider(this.getContentProvider());
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        ISelectionChangedListener selectionAdapter = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                EModelTableEditor.this.tableSelectionChanged();
            }
        };
        this.tableViewer.addSelectionChangedListener(selectionAdapter);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
    }

    private void initializeTableHeader() {
        String[] columns = this.getColumnNames();
        int[] columnWidth = this.getColumnWidth();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(this.tableViewer.getTable(), 16384);
            column.setWidth(columnWidth[i]);
            column.setText(columns[i]);
            ++i;
        }
    }

    private void initializeTableItem() {
        this.getTableViewer().setInput(this.getElements());
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void updateTable() {
        this.getTableViewer().refresh(true);
    }

    protected void tableSelectionChanged() {
        this.tableEditorComposite.changeButtonState();
    }

    protected EModelEditTableComposite getTableEditorComposite() {
        return this.tableEditorComposite;
    }

    public TElement getTElement() {
        return this.element;
    }

    protected abstract String[] getColumnNames();

    protected abstract Object getElements();

    protected abstract int[] getColumnWidth();

    protected abstract CellEditor[] getCellEditors();

    protected abstract ICellModifier getCellModifiers();

    protected abstract IContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();
}

