/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.editpart;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DRelativePoint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import trier.TrierPlugin;
import trier.diagrameditor.EConnectionRouterFactory;
import trier.diagrameditor.EEditor;
import trier.diagrameditor.action.ESetLooksRequest;
import trier.diagrameditor.editpart.policy.EConnectionBendpointEditPolicy;
import trier.diagrameditor.editpart.policy.EConnectionEditPolicy;
import trier.diagrameditor.editpart.policy.EContainerXYLayoutEditPolicy;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;

public abstract class EConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private static final Logger logger;
    private static final Object TEMP;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.editpart.EConnectionEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        TEMP = new Object();
    }

    public EElement getElement() {
        return (EElement)this.getModel();
    }

    public DElement getDElement() {
        return this.getElement().getDModel();
    }

    public EEditDomain getEditDomain() {
        return (EEditDomain)this.getViewer().getEditDomain();
    }

    public EDocument getDocument() {
        return this.getEditDomain().getDocument();
    }

    public DConnection getDConnection() {
        return (DConnection)this.getDElement();
    }

    protected PolylineConnection getDConnectionFigure() {
        return (PolylineConnection)this.getFigure();
    }

    protected List getModelChildren() {
        if (this.getParent() == null) {
            return new ArrayList();
        }
        return this.getDocument().getElementsByDElements(this.getDConnection().getLabels());
    }

    protected IFigure createFigure() {
        Connection figure = this.getEditDomain().getConnectionFigureFactory().createConnectionFigure(this.getElement().getType());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicies();
    }

    protected void installEditPolicies() {
        super.installEditPolicy((Object)"ConnectionEditPolicy", (EditPolicy)new EConnectionEditPolicy());
        super.installEditPolicy((Object)"Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.initializeBendpointEditPolicy();
    }

    protected void initializeBendpointEditPolicy() {
        if (this.getDConnection().getConnectionType() == 1) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new EConnectionBendpointEditPolicy());
        } else if (this.getDConnection().getConnectionType() == 2) {
            this.installEditPolicy("Connection Bendpoint Policy", null);
        } else {
            throw new RuntimeException("Illegal ConnectionType");
        }
    }

    public void activate() {
        if (!super.isActive()) {
            super.activate();
            this.getElement().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (super.isActive()) {
            this.getElement().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    public boolean understandsRequest(Request request) {
        if (request.getType().equals("open") || request.getType().equals("$set line type") || request.getType().equals("$delete model")) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public void performRequest(Request request) {
        if (request.getType().equals("open")) {
            this.showDirectEditor();
        } else if (request.getType().equals("property edit")) {
            this.showPropertyEditor();
        } else if (request.getType().equals("$delete model")) {
            this.deleteFromModel();
        } else if (request.getType().equals("$set line type")) {
            this.setLineType(((ESetLooksRequest)request).getLooksType());
        }
    }

    private void deleteFromModel() {
        IEditorReference[] editors = TrierPlugin.getDefault().getActivePage().getEditorReferences();
        CompoundCommand commands = new CompoundCommand();
        int i = 0;
        while (i < editors.length) {
            EEditor eEditor;
            IEditorPart editorPart = editors[i].getEditor(false);
            if (editorPart instanceof EEditor && !(eEditor = (EEditor)editorPart).getEEditDomain().getDocument().getElementsByTElement(this.getElement().getTModel()).isEmpty()) {
                Command command = eEditor.getEEditDomain().createRemoveEElementFromModelCommand(this.getElement().getTModel());
                commands.add(command);
            }
            ++i;
        }
        if (!commands.isEmpty()) {
            this.getEditDomain().getCommandStack().execute((Command)commands);
        }
    }

    protected void setLineType(int type) {
        Command command = this.getEditDomain().getDCommandFactory().createSetConnectionTypeCommand(this.getDConnection(), type);
        this.getEditDomain().getCommandStack().execute(command);
    }

    protected abstract void showDirectEditor();

    protected abstract void showPropertyEditor();

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshConnectionType();
        this.refreshBendpoints();
    }

    private void refreshConnectionType() {
        int connectionType = this.getDConnection().getConnectionType();
        ConnectionRouter router = EConnectionRouterFactory.getConnectionRouter(connectionType);
        this.getConnectionFigure().setConnectionRouter(router);
        this.initializeBendpointEditPolicy();
    }

    protected void refreshBendpoints() {
        if (!(this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter)) {
            List bendpoints = this.getDConnection().getBendpoints();
            ArrayList<RelativeBendpoint> constraint = new ArrayList<RelativeBendpoint>();
            Iterator i = bendpoints.iterator();
            while (i.hasNext()) {
                DRelativePoint p = (DRelativePoint)i.next();
                RelativeBendpoint bp = new RelativeBendpoint((Connection)this.getDConnectionFigure());
                bp.setRelativeDimensions(p.getD1(), p.getD2());
                bp.setWeight(p.getWeight());
                constraint.add(bp);
            }
            this.getDConnectionFigure().setRoutingConstraint(constraint);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("connectionType")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("bendpoints")) {
            this.refreshBendpoints();
        } else if (evt.getPropertyName().equals("labels")) {
            this.refreshChildren();
        } else if (evt.getPropertyName().equals("constraint")) {
            super.refresh();
        }
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("move children")) {
            TempXYLayoutEditPolicy policy = new TempXYLayoutEditPolicy();
            this.installEditPolicy(TEMP, (EditPolicy)policy);
            ChangeBoundsRequest req = (ChangeBoundsRequest)request;
            List editparts = req.getEditParts();
            EditPart editpart = (EditPart)editparts.get(0);
            Rectangle r = new Rectangle(((GraphicalEditPart)editpart).getFigure().getBounds());
            ((GraphicalEditPart)editpart).getFigure().translateToAbsolute((Translatable)r);
            r.translate(req.getMoveDelta());
            Command command = policy.createMoveLabelCommandImpl(editpart, r);
            this.installEditPolicy(TEMP, null);
            return command;
        }
        return super.getCommand(request);
    }

    class TempXYLayoutEditPolicy
    extends EContainerXYLayoutEditPolicy {
        TempXYLayoutEditPolicy() {
        }

        protected Command createAddNodeCommandImpl(EElement element, Rectangle r) {
            return null;
        }

        protected Point getAbsolutePoint(Point point) {
            return point;
        }
    }
}

