/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.editpart.policy;

import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import trier.diagrameditor.editpart.EConnectionEditPart;
import trier.diagrameditor.editpart.ELabelLocator;
import trier.diagrameditor.editpart.ERootEditPart;
import trier.diagrameditor.model.EConnectionDelayEElement;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;

public abstract class EContainerXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.editpart.policy.EContainerXYLayoutEditPolicy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected EEditDomain getDomain() {
        return (EEditDomain)this.getHost().getRoot().getViewer().getEditDomain();
    }

    protected Command createAddCommand(EditPart childPart, Object constraint) {
        EElement eElement = (EElement)childPart.getModel();
        if (!(eElement instanceof EConnectionDelayEElement) && eElement.getDModel() instanceof DLabel) {
            return this.createMoveLabelCommandImpl(childPart, (Rectangle)constraint);
        }
        return this.createAddNodeCommandImpl(eElement, (Rectangle)constraint);
    }

    protected Command getCreateCommand(CreateRequest req) {
        EElement eElement = (EElement)req.getNewObject();
        Rectangle r = (Rectangle)this.getConstraintFor(req);
        return this.createAddNodeCommandImpl(eElement, r);
    }

    protected Command createChangeConstraintCommand(EditPart childPart, Object constraint) {
        DElement dElement = ((EElement)childPart.getModel()).getDModel();
        return this.createMoveNodeCommandImpl((DNode)dElement, (Rectangle)constraint);
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return this.createOrphanChildrenImpl(((GroupRequest)request).getEditParts());
    }

    protected EditPolicy createChildEditPolicy(EditPart childPart) {
        DElement dElement = ((EElement)childPart.getModel()).getDModel();
        if (dElement instanceof DNode) {
            return new ResizableEditPolicy();
        }
        return new NonResizableEditPolicy();
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected abstract Command createAddNodeCommandImpl(EElement var1, Rectangle var2);

    protected Command createMoveNodeCommandImpl(DNode node, Rectangle r) {
        return this.getDomain().getDCommandFactory().createSetBoundsCommand(node, r);
    }

    protected Command createOrphanChildrenImpl(List children) {
        CompoundCommand removes = new CompoundCommand("Orphan Command");
        Iterator i = children.iterator();
        while (i.hasNext()) {
            EElement child = (EElement)((EditPart)i.next()).getModel();
            removes.add(this.getDomain().createRemoveEElementFromModelCommand(child.getTModel()));
        }
        return removes;
    }

    public Command createMoveLabelCommandImpl(EditPart child, Rectangle r) {
        Point p = r.getLocation();
        p = this.getAbsolutePoint(p);
        IFigure figure = ((GraphicalEditPart)child).getFigure();
        p.x += figure.getSize().width / 2;
        p.y += figure.getSize().height / 2;
        Point source = ELabelLocator.getSourcePoint(this.getConnection(child));
        Point target = ELabelLocator.getTargetPoint(this.getConnection(child));
        DRelativePoint rp = DRelativePoint.createInstance((Point)p, (Point)source, (Point)target);
        DLabel label = (DLabel)((EElement)child.getModel()).getDModel();
        return this.getDomain().getDCommandFactory().createSetLocationCommand(label, rp);
    }

    private Connection getConnection(EditPart child) {
        return (Connection)((EConnectionEditPart)child.getParent()).getFigure();
    }

    protected Point getAbsolutePoint(Point point) {
        Point p = point.getCopy();
        EditPart editpart = this.getHost();
        IFigure figure = this.getHostFigure();
        figure.translateToAbsolute((Translatable)p);
        if (!(editpart instanceof ERootEditPart)) {
            p.translate(figure.getBounds().getLocation());
        }
        return p;
    }
}

