/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.editpart.policy;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Color;
import trier.diagrameditor.editpart.ELabelEditPart;

public class ENodeHighlightEditPolicy
extends GraphicalEditPolicy {
    private static final Logger logger;
    private Border highlighter = new HighlightBorder(ColorConstants.darkBlue, 3);
    private Border revert;
    private boolean isHighlight = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.editpart.policy.EContainerXYLayoutEditPolicy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("move") || request.getType().equals("connection start") || request.getType().equals("connection end") || request.getType().equals("create child")) {
            this.setHighlight(true);
        } else if (request.getType().equals("add children")) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
            if (this.containtsLabelOnly(cbr.getEditParts())) {
                return;
            }
            this.setHighlight(true);
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.setHighlight(false);
    }

    private boolean containtsLabelOnly(List editparts) {
        Iterator i = editparts.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof ELabelEditPart) continue;
            return false;
        }
        return true;
    }

    protected void setHighlight(boolean highlight) {
        if (!this.isHighlight && highlight) {
            this.showHighlight();
            this.isHighlight = true;
        }
        if (this.isHighlight && !highlight) {
            this.eraseHighlight();
            this.isHighlight = false;
        }
    }

    private void showHighlight() {
        this.revert = this.getContainerFigure().getBorder();
        this.getContainerFigure().setBorder(this.highlighter);
        this.getContainerFigure().repaint();
    }

    private void eraseHighlight() {
        this.getContainerFigure().setBorder(this.revert);
        this.getContainerFigure().repaint();
    }

    class HighlightBorder
    extends LineBorder {
        HighlightBorder(Color c, int width) {
            super(c, width);
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0);
        }
    }
}

