/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.model;

import diagrammodelfw.model.DDocument;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import trier.diagrameditor.model.EElement;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TModelElement;

public abstract class EDocument
extends EElement {
    private static final Logger logger;
    private Map elementsByTElement = new HashMap();
    private Map elementsByDElement = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.model.EDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public EDocument(TElement tModel, DElement dModel) {
        super(tModel, dModel);
        this.buildupElementStructure();
    }

    protected void buildupElementStructure() {
        this.elementsByTElement.clear();
        List dElements = this.getDDocument().getAllElements();
        Iterator i = dElements.iterator();
        while (i.hasNext()) {
            DElement dElement = (DElement)i.next();
            TModelElement tElement = this.getTDocument().getTElement(dElement.getId());
            EElement eElement = new EElement(tElement, dElement);
            if (tElement != null) {
                this.addEElement(eElement);
                continue;
            }
            logger.warn((Object)("TElement has been removed. dElement=" + dElement + " ID=" + dElement.getId()));
            this.getDDocument().removeElement(dElement);
        }
    }

    public TDocument getTDocument() {
        return (TDocument)this.getTModel();
    }

    public DDocument getDDocument() {
        return (DDocument)this.getDModel();
    }

    public List getAllElements() {
        return new ArrayList(this.elementsByDElement.values());
    }

    public EElement createNodeElement(TElement tElement) {
        return new EElement(tElement, (DElement)this.getDDocument().createNode(tElement.getId()));
    }

    public abstract EElement createNodeElement(String var1);

    public abstract EElement createConnectionEElement(String var1, DNode var2, DNode var3);

    public void addEElement(EElement element) {
        if (!this.getAllElements().contains(element)) {
            ArrayList<EElement> eElements;
            logger.info((Object)("EDocument#addEElement(TElement-Id=" + element.getTModel().getId() + " Type=" + element.getTModel().getElementType() + ")"));
            if (element.getTModel().isRemoved()) {
                this.getTDocument().comeBack((TModelElement)element.getTModel());
            }
            if ((eElements = (ArrayList<EElement>)this.elementsByTElement.get(element.getTModel())) == null) {
                eElements = new ArrayList<EElement>();
                this.elementsByTElement.put(element.getTModel(), eElements);
            }
            eElements.add(element);
            if (element.getDModel() != null) {
                this.elementsByDElement.put(element.getDModel(), element);
            }
        }
    }

    public void removeEElement(EElement element) {
        if (this.getAllElements().contains(element)) {
            this.elementsByTElement.remove(element.getTModel());
            this.elementsByDElement.remove(element.getDModel());
        }
    }

    public List getAllNodeElements() {
        return this.getElementsByDElements(this.getDDocument().getAllNodes());
    }

    public List getAllLabelElements() {
        return this.getElementsByDElements(this.getDDocument().getAllLabels());
    }

    public List getAllConnectionElements() {
        return this.getElementsByDElements(this.getDDocument().getAllConnections());
    }

    public EElement getElement(DElement dElement) {
        return (EElement)this.elementsByDElement.get(dElement);
    }

    public List getElementsByDElements(Collection dElements) {
        ArrayList<EElement> elements = new ArrayList<EElement>();
        Iterator i = dElements.iterator();
        while (i.hasNext()) {
            elements.add(this.getElement((DElement)i.next()));
        }
        return elements;
    }

    public List getElementsByTElement(TElement tElement) {
        List list = (List)this.elementsByTElement.get(tElement);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public List getElementsByTElementsWithCreate(List tElements) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < tElements.size()) {
            TElement tElement = (TElement)tElements.get(i);
            list.addAll(this.getElementsByTElementWithCreate(tElement));
            ++i;
        }
        return list;
    }

    public List getElementsByTElementWithCreate(TElement tElement) {
        if (tElement == null) {
            return Collections.EMPTY_LIST;
        }
        if (!this.elementsByTElement.containsKey(tElement)) {
            this.addEElement(this.createEmptyElement(tElement));
        }
        return (List)this.elementsByTElement.get(tElement);
    }

    private EElement createEmptyElement(TElement tElement) {
        return new EElement(tElement, null);
    }

    public abstract TElement getDiagramOwner();
}

