/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.svg;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import trier.diagrameditor.EEditor;
import trier.diagrameditor.svg.ExportSVGOperation;

public class EExportSVGAction
extends EditorPartAction {
    public static final String ID = "$export svg";
    public static final String TEXT = "Export SVG";
    public static final String TOOLTIP_TEXT = "Export SVG";

    public EExportSVGAction(IEditorPart editor) {
        super(editor);
    }

    protected void init() {
        super.init();
        this.setId(ID);
        this.setText("Export SVG");
        this.setToolTipText("Export SVG");
    }

    protected boolean calculateEnabled() {
        return this.getEditorPart() instanceof EEditor;
    }

    public void run() {
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                EExportSVGAction.this.saveAsSVG((IProgressMonitor)monitorWrap);
            }
        };
        IWorkbenchWindow window = this.getEditorPart().getEditorSite().getWorkbenchWindow();
        Object ctx = window instanceof ApplicationWindow ? window : new ProgressMonitorDialog(window.getShell());
        try {
            ctx.run(false, true, progressOp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void saveAsSVG(IProgressMonitor monitor) {
        try {
            if (!(this.getEditorPart() instanceof EEditor)) {
                return;
            }
            EEditor editor = (EEditor)this.getEditorPart();
            String filename = editor.getFile().getName();
            int index = filename.lastIndexOf(46);
            if (index != -1) {
                filename = filename.substring(0, index);
            }
            filename = String.valueOf(filename) + ".svg";
            IContainer container = editor.getFile().getParent();
            IPath filePath = container.getFullPath().append("/" + filename);
            IFile file = WorkbenchPlugin.getPluginWorkspace().getRoot().getFile(filePath);
            if (file.exists()) {
                file.setContents(this.getContents(editor), true, false, monitor);
            } else {
                file.create(this.getContents(editor), false, monitor);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected InputStream getContents(EEditor editor) throws Exception {
        ExportSVGOperation operation = new ExportSVGOperation(editor.getGraphicalViewer());
        return operation.createExportStream();
    }
}

