/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import trier.model.core.TAssociation;
import trier.model.core.TAssociationEnd;
import trier.model.core.TAttribute;
import trier.model.core.TClassifier;
import trier.model.core.TGeneralization;
import trier.model.core.TMetaClass;
import trier.model.core.TMethod;
import trier.model.core.TModelElement;
import trier.model.core.TModifiedElement;
import trier.model.core.TModifier;
import trier.model.core.TVisibilityKind;

public class TClass
extends TClassifier
implements TModifiedElement {
    private static final Logger logger;
    private List $referedGeneralizations = new ArrayList();
    private List $referedAssociationEnds = new ArrayList();
    private List methods = new ArrayList();
    private List attributes = new ArrayList();
    private boolean isInterface = false;
    private TModifier modifier = new TModifier();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public TClass(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    protected void remove() {
        super.remove();
        this.removeElements(this.getAttributes());
        this.removeElements(this.getMethods());
        this.removeElements(this.getReferedAssociations());
        Iterator i = this.getReferedGeneralizations().iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            if (generalization.getMetaClass().isRemoved(generalization)) {
                generalization.remove();
                continue;
            }
            generalization.removeChildClass(this);
        }
    }

    protected void comeBack() {
        super.comeBack();
        this.comeBackElements(this.getAttributes());
        this.comeBackElements(this.getMethods());
        this.comeBackElements(this.getReferedAssociations());
        Iterator i = this.getReferedGeneralizations().iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            if (!generalization.getMetaClass().isRemoved(generalization)) continue;
            generalization.comeBack();
        }
    }

    public List getModelChildren() {
        TModelElement element;
        ArrayList<TModelElement> children = new ArrayList<TModelElement>();
        Iterator i = this.methods.iterator();
        while (i.hasNext()) {
            element = (TModelElement)i.next();
            children.add(element);
            children.addAll(element.getModelChildren());
        }
        i = this.attributes.iterator();
        while (i.hasNext()) {
            element = (TModelElement)i.next();
            children.add(element);
            children.addAll(element.getModelChildren());
        }
        return children;
    }

    public String getFQCN() {
        if (this.getNamespace().getName().equals("default")) {
            return this.getName();
        }
        return String.valueOf(this.getNamespace().toString()) + "." + this.getName();
    }

    public String getElementType() {
        return "Class";
    }

    public TModifier getModifier() {
        return this.modifier;
    }

    protected void addMethod(TMethod method) {
        this.methods.add(method);
        this.fireStructureChange("TModelElement changed");
    }

    protected void insertMethod(TMethod method, int index) {
        this.methods.add(index, method);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeMethod(TMethod method) {
        this.methods.remove(method);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveUpMethod(TMethod method) {
        this.move(method, this.methods, -1);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveDownMethod(TMethod method) {
        this.move(method, this.methods, 1);
        this.fireStructureChange("TModelElement changed");
    }

    public List getMethods() {
        return new ArrayList(this.methods);
    }

    protected void addAttribute(TAttribute attribute) {
        this.attributes.add(attribute);
        this.fireStructureChange("TModelElement changed");
    }

    protected void insertAttribute(TAttribute attribute, int index) {
        this.attributes.add(index, attribute);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeAttribute(TAttribute attribute) {
        this.attributes.remove(attribute);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveUpAttribute(TAttribute attribute) {
        this.move(attribute, this.attributes, -1);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveDownAttribute(TAttribute attribute) {
        this.move(attribute, this.attributes, 1);
        this.fireStructureChange("TModelElement changed");
    }

    public List getAttributes() {
        return new ArrayList(this.attributes);
    }

    protected void fireStructureChange(String propertyName) {
        super.firePropertyChange(propertyName, null, null);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    protected void setInterface(boolean isInterface) {
        boolean oldIsInterface = this.isInterface;
        this.isInterface = isInterface;
        super.firePropertyChange("TModelElement changed", (Object)new Boolean(oldIsInterface), (Object)new Boolean(this.isInterface));
    }

    public boolean isAbstract() {
        return this.modifier.isAbstract();
    }

    protected void setAbstract(boolean isAbstract) {
        boolean oldIsAbstract = this.modifier.isAbstract();
        this.modifier.setAbstract(isAbstract);
        super.firePropertyChange("TModelElement changed", (Object)new Boolean(oldIsAbstract), (Object)new Boolean(isAbstract));
    }

    public boolean isFinal() {
        return this.modifier.isFinal();
    }

    protected void setFinal(boolean isFinal) {
        boolean oldIsFinal = this.modifier.isFinal();
        this.modifier.setFinal(isFinal);
        this.firePropertyChange("TModelElement changed", new Boolean(oldIsFinal), new Boolean(isFinal));
    }

    public boolean isStatic() {
        return this.modifier.isStatic();
    }

    protected void setStatic(boolean isStatic) {
        boolean oldIsStatic = this.modifier.isStatic();
        this.modifier.setStatic(isStatic);
        this.firePropertyChange("TModelElement changed", new Boolean(oldIsStatic), new Boolean(isStatic));
    }

    public TVisibilityKind getVisibilityKind() {
        return this.modifier.getVisibility();
    }

    protected void setVisibilityKind(TVisibilityKind visibilityKind) {
        this.firePropertyChange("TModelElement changed", this.modifier.getVisibility(), visibilityKind);
        this.modifier.setVisibility(visibilityKind);
    }

    protected void addReferedAssociationEnd(TAssociationEnd associationEnd) {
        this.$referedAssociationEnds.add(associationEnd);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeReferedAssociationEnd(TAssociationEnd associationEnd) {
        this.$referedAssociationEnds.remove(associationEnd);
        this.fireStructureChange("TModelElement changed");
    }

    public Collection getReferedAssociations() {
        HashSet<TAssociation> associations = new HashSet<TAssociation>();
        Iterator i = this.$referedAssociationEnds.iterator();
        while (i.hasNext()) {
            TAssociationEnd associationEnd = (TAssociationEnd)i.next();
            associations.add(associationEnd.getAssociation());
        }
        return associations;
    }

    protected List getReferedAssociatitonEnds() {
        return new ArrayList(this.$referedAssociationEnds);
    }

    protected void addReferedGeneralization(TGeneralization generalization) {
        this.$referedGeneralizations.add(generalization);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeReferedGeneralization(TGeneralization generalization) {
        this.$referedGeneralizations.remove(generalization);
        this.fireStructureChange("TModelElement changed");
    }

    public Collection getReferedGeneralizations() {
        return new ArrayList(this.$referedGeneralizations);
    }

    public Collection getGeneralizationsToChild() {
        ArrayList<TGeneralization> generalizations = new ArrayList<TGeneralization>();
        Iterator i = this.$referedGeneralizations.iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            if (!generalization.getParentClass().equals(this)) continue;
            generalizations.add(generalization);
        }
        return generalizations;
    }

    public Collection getGeneralizationsToParent() {
        ArrayList<TGeneralization> generalizations = new ArrayList<TGeneralization>();
        Iterator i = this.$referedGeneralizations.iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            if (!generalization.getChildClasses().contains(this)) continue;
            generalizations.add(generalization);
        }
        return generalizations;
    }

    public Collection getSubClassesRecursively() {
        HashSet<TClass> subClasses = new HashSet<TClass>();
        Iterator i = this.getGeneralizationsToChild().iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            Iterator j = generalization.getChildClasses().iterator();
            while (j.hasNext()) {
                TClass subClass = (TClass)j.next();
                subClasses.add(subClass);
                subClasses.addAll(subClass.getSubClassesRecursively());
            }
        }
        return subClasses;
    }

    public Collection getSuperClassesRecursively() {
        HashSet<Object> superClasses = new HashSet<Object>();
        Iterator i = this.getGeneralizationsToParent().iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            superClasses.add(generalization.getParentClass());
            superClasses.add(generalization.getParentClass().getSuperClassesRecursively());
        }
        return superClasses;
    }

    private void move(Object target, List list, int direction) {
        int oldIndex = list.indexOf(target);
        int newIndex = oldIndex + direction;
        Object temp = list.get(newIndex);
        list.set(newIndex, target);
        list.set(oldIndex, temp);
    }

    public String getTagName() {
        return "Class";
    }
}

