/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectInputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectOutputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLSerializable;
import jp.ac.keio.sfc.crew.model.ModelObject;
import org.apache.log4j.Logger;
import trier.model.core.TAggregationKind;
import trier.model.core.TAnchor;
import trier.model.core.TAnchorDocumentHelper;
import trier.model.core.TAssociation;
import trier.model.core.TAssociationDocumentHelper;
import trier.model.core.TAssociationEnd;
import trier.model.core.TAssociationEndDocumentHelper;
import trier.model.core.TAttribute;
import trier.model.core.TClass;
import trier.model.core.TClassDocumentHelper;
import trier.model.core.TClassifier;
import trier.model.core.TDataType;
import trier.model.core.TDocumentVaidator;
import trier.model.core.TElement;
import trier.model.core.TFeature;
import trier.model.core.TFeatureDocumentHelper;
import trier.model.core.TGeneralization;
import trier.model.core.TGeneralizationDocumentHelper;
import trier.model.core.TMethod;
import trier.model.core.TMethodDocumentHelper;
import trier.model.core.TModelCore;
import trier.model.core.TModelElement;
import trier.model.core.TModelElementDocumentHelper;
import trier.model.core.TModifiedElement;
import trier.model.core.TModifiedElementDocumentHelper;
import trier.model.core.TMultiplicity;
import trier.model.core.TMultiplicityDocumentHelper;
import trier.model.core.TNamespace;
import trier.model.core.TNamespaceDocumentHelper;
import trier.model.core.TNote;
import trier.model.core.TPackage;
import trier.model.core.TParameter;
import trier.model.core.TRole;
import trier.model.core.TStereoType;
import trier.model.core.TTypedElement;
import trier.model.core.TTypedElementDocumentHelper;
import trier.model.core.TVisibilityKind;
import trier.model.object.TInstance;
import trier.model.object.TInstanceVariable;
import trier.model.object.TLink;
import trier.model.object.TLinkSource;
import trier.model.object.TObjectModel;
import trier.model.object.TObjectModelDocumentHelper;
import trier.model.object.TValue;
import trier.model.sequence.TActor;
import trier.model.sequence.TMessage;
import trier.model.sequence.TMessageLabel;
import trier.model.sequence.TSequenceModel;
import trier.model.sequence.TSequenceModelDocumentHelper;
import trier.model.sequence.TSequenciableElement;
import trier.model.sequence.TSequenciableObject;
import trier.model.state.TActivityState;
import trier.model.state.TCompositeState;
import trier.model.state.TDecision;
import trier.model.state.TDecisionLabel;
import trier.model.state.TFinalState;
import trier.model.state.TGuardCondition;
import trier.model.state.TInitialState;
import trier.model.state.TRootStateMachine;
import trier.model.state.TState;
import trier.model.state.TStateDocumentHelper;
import trier.model.state.TStateMachine;
import trier.model.state.TTransition;
import trier.model.state.TTransitionLabel;

public class TDocument
extends ModelObject
implements TElement,
XMLSerializable {
    private static final Logger logger;
    public static final String ROLE = "Role";
    public static final String DATA_TYPE = "DataType";
    public static final String PARAMETER = "Parameter";
    public static final String PACKAGE = "Package";
    public static final String MULTIPLICITY = "Multiplicity";
    public static final String METHOD = "Method";
    public static final String GENERALIZATION = "Generalization";
    public static final String DOCUMENT = "Document";
    public static final String CLASS = "Class";
    public static final String ATTRIBUTE = "Attribute";
    public static final String ASSOCIATION_END = "AssociationEnd";
    public static final String ASSOCIATION = "Association";
    public static final String STEREO_TYPE = "StereoType";
    public static final String INTERFACE = "Interface";
    public static final String NULL_OBJECT = "NullObject";
    public static final String MODIFIER = "modifier";
    public static final String NOTE = "Note";
    public static final String ANCHOR = "Anchor";
    public static final String DEPENDENCY = "Dependency";
    public static final String DEFAULT = "default";
    public static final String INITIAL_STATE = "InitialState";
    public static final String FINAL_STATE = "FinalState";
    public static final String ACTIVITY_STATE = "ActivityState";
    public static final String STATE = "State";
    public static final String TRANSITION = "Transition";
    public static final String DECISION = "Decision";
    public static final String TRANSITION_LABEL = "TransitionLabel";
    public static final String GUARD = "Guard";
    public static final String ROOT_STATE_MACHINE = "RootStateMachine";
    public static final String DECISION_LABEL = "DecisionLabel";
    public static final String MESSAGE = "Message";
    public static final String SEQUENCE_MODEL = "SequenceModel";
    public static final String SEQUENCIABLE_OBJECT = "SequenciableObject";
    public static final String ACTOR = "Actor";
    public static final String MESSAGE_LABEL = "MessageLabel";
    public static final String LINK = "Link";
    public static final String OBJECT_MODEL = "ObjectModel";
    public static final String INSTANCE = "Instance";
    public static final String INSTANCE_VARIABLE = "InstanceVariable";
    public static final String INSTANCE_VARIABLE_VALUE = "InstanceVariableValue";
    private static final String VALIDATION_CHECK_MESSAGE_AFTER = "TDocument validation check failed(after).";
    private static final String VALIDATION_CHECK_MESSAGE_BEFORE = "TDocument validation check failed(before).";
    public static String[] PRIMITIVE_TYPES;
    public static String[] STEREO_TYPES;
    private TModelCore core;
    private TPackage defaultPackage;
    private transient TClassDocumentHelper classHelper;
    private transient TNamespaceDocumentHelper namespaceHelper;
    private transient TModelElementDocumentHelper modelElementHelper;
    private transient TAssociationDocumentHelper associationHelper;
    private transient TAssociationEndDocumentHelper associationEndHelper;
    private transient TFeatureDocumentHelper featureHelper;
    private transient TGeneralizationDocumentHelper generalizationHelper;
    private transient TMethodDocumentHelper methodHelper;
    private transient TMultiplicityDocumentHelper multiplicityHelper;
    private transient TTypedElementDocumentHelper typedElementHelper;
    private transient TModifiedElementDocumentHelper modifiedElementHelper;
    private transient TAnchorDocumentHelper anchorDocumentHelper;
    private transient TStateDocumentHelper stateDocumentHelper;
    private transient TSequenceModelDocumentHelper sequenceDocumentHelper;
    private transient TObjectModelDocumentHelper objectDocumentHelper;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.core.TDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
        PRIMITIVE_TYPES = new String[]{"String", "short", "char", "int", "double", "boolean", "long", "float", "byte", "String[]", "short[]", "char[]", "int[]", "double[]", "boolean[]", "long[]", "float[]", "byte[]", "Date"};
        STEREO_TYPES = new String[]{"type", "parametarized", "factory"};
    }

    public TDocument() {
        this.initializeModelCore();
        this.initializeHelpers();
    }

    protected void initializeModelCore() {
        this.core = new TModelCore();
    }

    protected void initializeHelpers() {
        this.modelElementHelper = new TModelElementDocumentHelper(this);
        this.namespaceHelper = new TNamespaceDocumentHelper(this);
        this.associationEndHelper = new TAssociationEndDocumentHelper(this);
        this.associationHelper = new TAssociationDocumentHelper(this);
        this.classHelper = new TClassDocumentHelper(this);
        this.featureHelper = new TFeatureDocumentHelper(this);
        this.generalizationHelper = new TGeneralizationDocumentHelper(this);
        this.methodHelper = new TMethodDocumentHelper(this);
        this.multiplicityHelper = new TMultiplicityDocumentHelper(this);
        this.typedElementHelper = new TTypedElementDocumentHelper(this);
        this.modifiedElementHelper = new TModifiedElementDocumentHelper(this);
        this.anchorDocumentHelper = new TAnchorDocumentHelper(this);
        this.stateDocumentHelper = new TStateDocumentHelper(this);
        this.sequenceDocumentHelper = new TSequenceModelDocumentHelper(this);
        this.objectDocumentHelper = new TObjectModelDocumentHelper(this);
    }

    public void initializeDefaultModels() {
        this.defaultPackage = this.core.createTPackage();
        this.core.addInstance(this.defaultPackage);
        this.setName(this.defaultPackage, DEFAULT);
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            TDataType primitiveType = this.createDataType(PRIMITIVE_TYPES[i]);
            this.addOwnedElement(this.defaultPackage, primitiveType);
            ++i;
        }
        i = 0;
        while (i < STEREO_TYPES.length) {
            TStereoType stereoType = this.createStereoType(STEREO_TYPES[i]);
            this.addOwnedElement(this.defaultPackage, stereoType);
            ++i;
        }
    }

    public TModelCore getModelCore() {
        return this.core;
    }

    protected void setModel(TModelCore core) {
        this.core = core;
    }

    public TPackage getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(TPackage defaultPackage) {
        if (this.defaultPackage != null) {
            throw new UnsupportedOperationException("this document already has default package.");
        }
        this.defaultPackage = defaultPackage;
    }

    public String getId() {
        return "root";
    }

    public String getElementType() {
        return DOCUMENT;
    }

    public boolean isRemoved() {
        throw new UnsupportedOperationException("Document is not removed.");
    }

    public List getAllTModelElements() {
        return this.core.getAllTModelElements();
    }

    public TVisibilityKind getVisibilityKind(String key) {
        return TVisibilityKind.getVisibilityKind(key);
    }

    public List getVisibilityKinds() {
        return TVisibilityKind.getAllVisibilityKind();
    }

    public TAggregationKind getAggregationKind(String key) {
        return TAggregationKind.getAggregationKind(key);
    }

    public List getAggregationKinds() {
        return TAggregationKind.getAllAggregationKind();
    }

    public List getAllDataTypes() {
        return this.core.getTDataTypeClass().getAllInstances();
    }

    public List getAllClasses() {
        return this.core.getTClassClass().getAllInstances();
    }

    public List getAllClassifiers() {
        ArrayList classifiers = new ArrayList(this.core.getTClassClass().getAllInstances());
        classifiers.addAll(this.core.getTDataTypeClass().getAllInstances());
        return classifiers;
    }

    public List getAllGeneralizations() {
        return this.core.getTGeneralizationClass().getAllInstances();
    }

    public List getAllAssociations() {
        return this.core.getTAssociationClass().getAllInstances();
    }

    public List getAllPackages() {
        return this.core.getTPackageClass().getAllInstances();
    }

    public List getAllStereoTypes() {
        return this.core.getTStereoTypeClass().getAllInstances();
    }

    public List getAllRoles() {
        return this.core.getTRoleClass().getAllInstances();
    }

    public List getAllMultiplicities() {
        return this.core.getTMultiplicityClass().getAllInstances();
    }

    public List getAllMethods() {
        return this.core.getTMethodClass().getAllInstances();
    }

    public List getAllAttributes() {
        return this.core.getTAttributeClass().getAllInstances();
    }

    public List getAllParameters() {
        return this.core.getTParameterClass().getAllInstances();
    }

    public List getAllAssociationEnds() {
        return this.core.getTAssociationEndClass().getAllInstances();
    }

    public List getAllNotes() {
        return this.core.getTNoteClass().getAllInstances();
    }

    public List getAllAnchors() {
        return this.core.getTAnchorClass().getAllInstances();
    }

    public TModelElement getTElement(String id) {
        return this.core.getTElement(id);
    }

    public TNote createNote(String id) {
        TNote newNote = this.core.createTNote(id);
        return newNote;
    }

    public TAnchor createDependency(String id) {
        TAnchor newDependency = this.core.createTAnchor(id);
        newDependency.setDependency(true);
        return newDependency;
    }

    public TAnchor createAnchor(String id) {
        TAnchor newAnchor = this.core.createTAnchor(id);
        return newAnchor;
    }

    public TPackage createPackage(String name, String id) {
        TPackage newPackage = this.core.createTPackage(id);
        newPackage.setName(name);
        return newPackage;
    }

    public TRole createRole(String id) {
        TRole newRole = this.core.createTRole(id);
        return newRole;
    }

    public TClass createInterface(String name, String id) {
        TClass newInterface = this.core.createTClass(id);
        newInterface.setName(name);
        newInterface.setInterface(true);
        return newInterface;
    }

    public TClass createClass(String name, String id) {
        TClass newClass = this.core.createTClass(id);
        newClass.setName(name);
        return newClass;
    }

    public TDataType createDataType(String name, String id) {
        TDataType newDataType = this.core.createTDataType(id);
        newDataType.setName(name);
        return newDataType;
    }

    public TGeneralization createGeneralization(String id) {
        return this.core.createTGeneralization(id);
    }

    public TAssociation createAssociation(String id) {
        TAssociation association = this.core.createTAssociation(id);
        return association;
    }

    public TAssociationEnd createAssociationEnd(String id) {
        TAssociationEnd associationEnd = this.core.createTAssociationEnd(id);
        return associationEnd;
    }

    public TAssociation createNavigableAssociation(String id) {
        TAssociation association = this.createAssociation(id);
        association.getTargetAssociationEnd().setNavigable(true);
        return association;
    }

    public TAssociation createAggregateAssociation(String id) {
        TAssociation association = this.createAssociation(id);
        association.getSourceAssociationEnd().setAggregationKind(TAggregationKind.AGGREGATION);
        return association;
    }

    public TAssociation createCompositeAssociation(String id) {
        TAssociation association = this.createAssociation(id);
        association.getSourceAssociationEnd().setAggregationKind(TAggregationKind.COMPOSITION);
        return association;
    }

    public TMultiplicity createMultiplicity(String id) {
        TMultiplicity multiplicity = this.core.createTMultiplicity(id);
        this.setName(multiplicity, "");
        return multiplicity;
    }

    public TAttribute createAttribute(String name, String id) {
        TAttribute attribute = this.core.createTAttribute(id);
        attribute.setName(name);
        return attribute;
    }

    public TParameter createParameter(String name, String id) {
        TParameter parameter = this.core.createTParameter(id);
        parameter.setName(name);
        return parameter;
    }

    public TMethod createMethod(String name, String id) {
        TMethod method = this.core.createTMethod(id);
        method.setName(name);
        return method;
    }

    public TStereoType createStereoType(String name, String id) {
        TStereoType stereoType = this.core.createTStereoType(id);
        stereoType.setName(name);
        return stereoType;
    }

    public TMessage createMessage(String id) {
        TMessage sequence = this.core.createTMessage(id);
        this.setMessageLabel(sequence, (TMessageLabel)this.core.getTMessageLabelMetaClass().getNullObject());
        return sequence;
    }

    public TMessageLabel createMessageLabel(String name, String id) {
        TMessageLabel message = this.core.createTMessageLabel(id);
        this.setName(message, name);
        return message;
    }

    public TSequenciableObject createSequenciableObject(String name, String id) {
        TSequenciableObject sequenciableObject = this.core.createTSequenciableObject(id);
        this.setName(sequenciableObject, name);
        return sequenciableObject;
    }

    public TActor createActor(String name, String id) {
        TActor actor = this.core.createTActor(id);
        this.setName(actor, name);
        return actor;
    }

    public TSequenceModel createSequenceModel(String id) {
        TSequenceModel sequenceModel = this.core.createTSequenceModel(id);
        return sequenceModel;
    }

    public TNote createNote() {
        TNote newNote = this.core.createTNote();
        return newNote;
    }

    public TAnchor createDependency() {
        TAnchor newDependency = this.core.createTAnchor();
        newDependency.setDependency(true);
        return newDependency;
    }

    public TAnchor createAnchor() {
        TAnchor newAnchor = this.core.createTAnchor();
        return newAnchor;
    }

    public TPackage createPackage(String name) {
        TPackage newPackage = this.core.createTPackage();
        newPackage.setName(name);
        return newPackage;
    }

    public TRole createRole() {
        TRole newRole = this.core.createTRole();
        return newRole;
    }

    public TClass createInterface(String name) {
        TClass newInterface = this.core.createTClass();
        newInterface.setName(name);
        newInterface.setInterface(true);
        return newInterface;
    }

    public TClass createClass(String name) {
        TClass newClass = this.core.createTClass();
        newClass.setName(name);
        return newClass;
    }

    public TDataType createDataType(String name) {
        TDataType newDataType = this.core.createTDataType();
        newDataType.setName(name);
        return newDataType;
    }

    public TGeneralization createGeneralization() {
        return this.core.createTGeneralization();
    }

    public TAssociation createAssociation() {
        TAssociation association = this.core.createTAssociation();
        TAssociationEnd source = this.core.createTAssociationEnd();
        TAssociationEnd target = this.core.createTAssociationEnd();
        this.setSourceAssociationEnd(association, source);
        this.setTargetAssociationEnd(association, target);
        return association;
    }

    public TAssociation createNavigableAssociation() {
        TAssociation association = this.createAssociation();
        association.getTargetAssociationEnd().setNavigable(true);
        return association;
    }

    public TAssociation createAggregateAssociation() {
        TAssociation association = this.createAssociation();
        association.getSourceAssociationEnd().setAggregationKind(TAggregationKind.AGGREGATION);
        return association;
    }

    public TAssociation createCompositeAssociation() {
        TAssociation association = this.createAssociation();
        association.getSourceAssociationEnd().setAggregationKind(TAggregationKind.COMPOSITION);
        return association;
    }

    public TMultiplicity createMultiplicity() {
        TMultiplicity multiplicity = this.core.createTMultiplicity();
        this.setName(multiplicity, "");
        return multiplicity;
    }

    public TAttribute createAttribute(String name) {
        TAttribute attribute = this.core.createTAttribute();
        attribute.setName(name);
        return attribute;
    }

    public TParameter createParameter(String name) {
        TParameter parameter = this.core.createTParameter();
        parameter.setName(name);
        return parameter;
    }

    public TMethod createMethod(String name) {
        TMethod method = this.core.createTMethod();
        method.setName(name);
        return method;
    }

    public TStereoType createStereoType(String name) {
        TStereoType stereoType = this.core.createTStereoType();
        stereoType.setName(name);
        return stereoType;
    }

    public TCompositeState createCompositeState(String name, String id) {
        TCompositeState compositeState = this.core.createTCompositeState(id);
        this.stateDocumentHelper.setName(compositeState, name);
        return compositeState;
    }

    public TActivityState createActivityState(String name, String id) {
        TActivityState activityState = this.core.createTActivityState(id);
        this.stateDocumentHelper.setName(activityState, name);
        return activityState;
    }

    public TFinalState createFinalState(String id) {
        TFinalState finalState = this.core.createTFinalState(id);
        return finalState;
    }

    public TInitialState createInitialState(String id) {
        TInitialState initialState = this.core.createTInitialState(id);
        return initialState;
    }

    public TDecision createDecision(String id) {
        TDecision decision = this.core.createTDecision(id);
        return decision;
    }

    public TRootStateMachine createRootStateMachine(String id) {
        TRootStateMachine rootStateMachine = this.core.createTRootStateMachine(id);
        return rootStateMachine;
    }

    public TGuardCondition createGuardCondition(String name, String id) {
        TGuardCondition guardCondition = this.core.createTGuardCondition(id);
        this.stateDocumentHelper.setName(guardCondition, name);
        return guardCondition;
    }

    public TTransition createTransition(String id) {
        TTransition transition = this.core.createTTransition(id);
        this.setGuardCondition(transition, (TGuardCondition)this.core.getTGuardConditionClass().getNullObject());
        return transition;
    }

    public TTransitionLabel createTransitionLabel(String id) {
        TTransitionLabel transitionLabel = this.core.createTTransitionLabel(id);
        return transitionLabel;
    }

    public TCompositeState createCompositeState(String name) {
        TCompositeState compositeState = this.core.createTCompositeState();
        this.stateDocumentHelper.setName(compositeState, name);
        return compositeState;
    }

    public TActivityState createActivityState(String name) {
        TActivityState activityState = this.core.createTActivityState();
        this.stateDocumentHelper.setName(activityState, name);
        return activityState;
    }

    public TFinalState createFinalState() {
        TFinalState finalState = this.core.createTFinalState();
        return finalState;
    }

    public TInitialState createInitialState() {
        TInitialState initialState = this.core.createTInitialState();
        return initialState;
    }

    public TDecision createDecision() {
        TDecision decision = this.core.createTDecision();
        this.setName(decision, "");
        return decision;
    }

    public TRootStateMachine createRootStateMachine() {
        TRootStateMachine rootStateMachine = this.core.createTRootStateMachine();
        return rootStateMachine;
    }

    public TGuardCondition createGuardCondition(String name) {
        TGuardCondition guardCondition = this.core.createTGuardCondition();
        this.stateDocumentHelper.setName(guardCondition, name);
        return guardCondition;
    }

    public TTransition createTransition() {
        TTransition transition = this.core.createTTransition();
        this.setTransitionLabel(transition, (TTransitionLabel)this.core.getTTransitionLabelClass().getNullObject());
        this.setGuardCondition(transition, (TGuardCondition)this.core.getTGuardConditionClass().getNullObject());
        return transition;
    }

    public TTransitionLabel createTransitionLabel() {
        TTransitionLabel transitionLabel = this.core.createTTransitionLabel();
        return transitionLabel;
    }

    public TMessage createMessage() {
        TMessage sequence = this.core.createTMessage();
        this.setMessageLabel(sequence, (TMessageLabel)this.core.getTMessageLabelMetaClass().getNullObject());
        return sequence;
    }

    public TMessageLabel createMessageLabel(String name) {
        TMessageLabel message = this.core.createTMessageLabel();
        this.setName(message, name);
        return message;
    }

    public TSequenciableObject createSequenciableObject(String name) {
        TSequenciableObject sequenciableObject = this.core.createTSequenciableObject();
        this.setName(sequenciableObject, name);
        return sequenciableObject;
    }

    public TActor createActor(String name) {
        TActor actor = this.core.createTActor();
        this.setName(actor, name);
        return actor;
    }

    public TSequenceModel createSequenceModel() {
        TSequenceModel sequenceModel = this.core.createTSequenceModel();
        return sequenceModel;
    }

    public TObjectModel createObjectModel() {
        TObjectModel sequenceModel = this.core.createTObjectModel();
        return sequenceModel;
    }

    public TInstance createInstance(String name) {
        TInstance instance = this.core.createTInstance();
        this.modelElementHelper.setName(instance, name);
        return instance;
    }

    public TLink createLink() {
        TLink link = this.core.createTLink();
        return link;
    }

    public TLink createNavigableLink() {
        TLink link = this.core.createTLink();
        this.objectDocumentHelper.setNavigable(link, true);
        return link;
    }

    public TInstanceVariable createInstanceVariable(String name) {
        TInstanceVariable variable = this.core.createTInstanceVariable();
        this.modelElementHelper.setName(variable, name);
        this.objectDocumentHelper.setValue(variable, (TValue)this.core.getTValueMetaClass().getNullObject());
        return variable;
    }

    public TValue createValue() {
        TValue value = this.core.createTValue();
        return value;
    }

    public void addModelEventListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void removeModelEventListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }

    public void setDescription(TNote note, String description) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modelElementHelper.setDescription(note, description);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setDescription(id=" + note.getId() + "->" + description + ")"));
    }

    public void relateAnchor(TNamespace namespace, TAnchor anchor, TModelElement source, TModelElement target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.anchorDocumentHelper.relateAnchor(namespace, anchor, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateAnchor(id=" + anchor.getId() + ":source:" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void reconnectTarget(TAnchor anchor, TModelElement target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.anchorDocumentHelper.reconnectTarget(anchor, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateAnchorTarget(id=" + anchor.getId() + "->target:" + target.getId() + ")"));
    }

    public void reconnectSource(TAnchor anchor, TModelElement source) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.anchorDocumentHelper.reconnectSource(anchor, source);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#reconnectAnchorSource(id=" + anchor.getId() + "->target:" + source.getId() + ")"));
    }

    public void relateDependency(TNamespace namespace, TAnchor dependency, TModelElement source, TModelElement target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.anchorDocumentHelper.relateAnchor(namespace, dependency, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateDependency(id=" + dependency.getId() + ":source:" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void setDependency(TAnchor anchor, boolean dependency) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.anchorDocumentHelper.setDependency(anchor, dependency);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setDependency(id=" + anchor.getId() + "->" + dependency + ")"));
    }

    public void setTargetAssociationEnd(TAssociation association, TAssociationEnd associationEnd) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationHelper.setTargetAssociationEnd(association, associationEnd);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setTarget(id=" + association.getId() + "->" + associationEnd.getId() + ")"));
    }

    public void setSourceAssociationEnd(TAssociation association, TAssociationEnd associationEnd) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationHelper.setSourceAssociationEnd(association, associationEnd);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setSource(id=" + association.getId() + "->" + associationEnd + ")"));
    }

    public void setName(TModelElement modelElement, String name) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modelElementHelper.setName(modelElement, name);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setName(id=" + modelElement.getId() + "->" + name + ")"));
    }

    public void setVisibility(TModifiedElement modifiedElement, TVisibilityKind kind) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modifiedElementHelper.setVisibility(modifiedElement, kind);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setModifier(id=" + ((TModelElement)((Object)modifiedElement)).getId() + "->" + kind.toString() + ")"));
    }

    public void setStereoType(TModelElement element, TStereoType stereoType) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modelElementHelper.setStereoType(element, stereoType);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setStereoType(id=" + element.getId() + "->" + stereoType.getId() + ")"));
    }

    public void setNamespace(TModelElement element, TNamespace namespace) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modelElementHelper.setNamespace(element, namespace);
        this.fireStructureChange("TModelElement changed");
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setNamespace(id=" + element.getId() + "->" + namespace.getId() + ")"));
    }

    public void addOwnedElement(TNamespace owner, TModelElement modelElement) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.namespaceHelper.addOwnedElement(owner, modelElement);
        this.fireStructureChange("TModelElement changed");
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addOwnedElement(id=" + owner.getId() + "->" + modelElement.getId() + ")"));
    }

    public void relateGeneralization(TNamespace namespace, TGeneralization generalization, TClass source, TClass target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.generalizationHelper.relateGeneralization(namespace, generalization, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateGeneralization(id=" + generalization.getId() + ":source:" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void setChild(TGeneralization generalization, TClass newChild) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.generalizationHelper.setChild(generalization, newChild);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setChild(id=" + generalization.getId() + "->" + newChild.getId() + ")"));
    }

    public void setParent(TGeneralization generalization, TClass newParent) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.generalizationHelper.setParent(generalization, newParent);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setParent(id=" + generalization.getId() + "->" + newParent.getId() + ")"));
    }

    public void addChild(TGeneralization generalization, TClass newChild) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.generalizationHelper.addChild(generalization, newChild);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addChild(id=" + generalization.getId() + "->" + newChild.getId() + ")"));
    }

    public void setChildren(TGeneralization generalization, List children) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.generalizationHelper.setChildren(generalization, children);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setChildren(id=" + generalization.getId() + "->" + children + ")"));
    }

    public void removeChild(TGeneralization generalization, TClass child) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.generalizationHelper.removeChild(generalization, child);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#removeChild(id=" + generalization.getId() + "->" + child.getId() + ")"));
    }

    public void relateAssociation(TNamespace namespace, TAssociation association, TClass source, TClass target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationHelper.relateAssociation(namespace, association, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateAssociation(id=source:" + association.getId() + ":" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void setRole(TAssociationEnd associationEnd, TRole role) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationEndHelper.setRole(associationEnd, role);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setRole(id=" + associationEnd.getId() + "->" + role.getId() + ")"));
    }

    public void setNavigable(TAssociationEnd associationEnd, boolean navigable) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationEndHelper.setNavigable(associationEnd, navigable);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setNavigable(id=" + associationEnd.getId() + "->" + navigable + ")"));
    }

    public void setMultiplicity(TAssociationEnd associationEnd, TMultiplicity multiplicity) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationEndHelper.setMultiplicity(associationEnd, multiplicity);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setMultiplicity(id=" + associationEnd.getId() + "->" + multiplicity.getId() + ")"));
    }

    public void setAggregationKind(TAssociationEnd associationEnd, TAggregationKind aggregationKind) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.associationEndHelper.setAggregationKind(associationEnd, aggregationKind);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setAggregationKind(id=" + associationEnd.getId() + "->" + aggregationKind + ")"));
    }

    public void setMultiplicityRange(TMultiplicity multiplicity, String value) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.multiplicityHelper.setMultiplicityRange(multiplicity, value);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setMultiplicityRange(id=" + multiplicity.getId() + "->" + value + ")"));
    }

    public void addAttribute(TClass owner, TAttribute attribute) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.addAttribute(owner, attribute);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addAttribute(id=" + owner.getId() + "->" + attribute.getId() + ")"));
    }

    public void addMethod(TClass owner, TMethod method) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.addMethod(owner, method);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addMethod(id=" + owner.getId() + "->" + method.getId() + ")"));
    }

    public void setAbstract(TModifiedElement modifiedElement, boolean isAbstract) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modifiedElementHelper.setAbstract(modifiedElement, isAbstract);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setAbstract(id=" + ((TModelElement)((Object)modifiedElement)).getId() + "->" + isAbstract + ")"));
    }

    public void setInterface(TClass clazz, boolean isInterface) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.setInterface(clazz, isInterface);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setInterface(id=" + clazz.getId() + "->" + isInterface + ")"));
    }

    public void setOwner(TFeature feature, TClass owner) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.featureHelper.setOwner(feature, owner);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setOwner(id=" + feature.getId() + "->" + owner.getId() + ")"));
    }

    public void setStatic(TModifiedElement modifiedElement, boolean isStatic) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modifiedElementHelper.setStatic(modifiedElement, isStatic);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setStatic(id=" + ((TModelElement)((Object)modifiedElement)).getId() + "->" + isStatic + ")"));
    }

    public void setFinal(TModifiedElement modifiedElement, boolean isFinal) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modifiedElementHelper.setFinal(modifiedElement, isFinal);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setFinal(id=" + ((TModelElement)((Object)modifiedElement)).getId() + "->" + isFinal + ")"));
    }

    public void setType(TTypedElement typedElement, TClassifier type) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.typedElementHelper.setType(typedElement, type);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setType(id=" + ((TModelElement)((Object)typedElement)).getId() + "->" + type.getId() + ")"));
    }

    public void addParameter(TMethod method, TParameter parameter) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.methodHelper.addParameter(method, parameter);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addParameter(id=" + method.getId() + "->" + parameter.getId() + ")"));
    }

    public void remove(TModelElement modelElement) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modelElementHelper.remove(modelElement);
        this.fireStructureChange("TModelElement changed");
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#remove(id=" + modelElement.getId() + ")"));
    }

    public void comeBack(TModelElement modelElement) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.modelElementHelper.comeBack(modelElement);
        this.fireStructureChange("TModelElement changed");
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#comeBack(id=" + modelElement.getId() + ")"));
    }

    public void moveUpMethod(TClass owner, TMethod method) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.moveUpMethod(owner, method);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#moveUpMethod(id=" + owner.getId() + "->" + method.getId() + ")"));
    }

    public void moveDownMethod(TClass owner, TMethod method) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.moveDownMethod(owner, method);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#moveDownMethod(id=" + owner.getId() + "->" + method.getId() + ")"));
    }

    public void moveUpAttribute(TClass owner, TAttribute attribute) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.moveUpAttribute(owner, attribute);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#moveUpAttribute(id=" + owner.getId() + "->" + attribute.getId() + ")"));
    }

    public void moveDownAttribute(TClass owner, TAttribute attribute) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.moveDownAttribute(owner, attribute);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#moveDownAttribute(id=" + owner.getId() + "->" + attribute.getId() + ")"));
    }

    public void moveUpParameter(TMethod owner, TParameter parameter) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.methodHelper.moveUpParameter(owner, parameter);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#moveUpParameter(id=" + owner.getId() + "->" + parameter.getId() + ")"));
    }

    public void moveDownParameter(TMethod owner, TParameter parameter) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.methodHelper.moveDownParameter(owner, parameter);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#moveDownParameter(id=" + owner.getId() + "->" + parameter.getId() + ")"));
    }

    public void insertParameter(TMethod owner, TParameter parameter, int index) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.methodHelper.insertParameter(owner, parameter, index);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#insetParameter(id=" + owner.getId() + "->" + parameter.getId() + "#" + index + ")"));
    }

    public void insertMethod(TClass owner, TMethod method, int index) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.insertMethod(owner, method, index);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#insetMethod(id=" + owner.getId() + "->" + method.getId() + "#" + index + ")"));
    }

    public void insertAttribute(TClass owner, TAttribute attribute, int index) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.classHelper.insertAttribute(owner, attribute, index);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#insetAttribute(id=" + owner.getId() + "->" + attribute.getId() + "#" + index + ")"));
    }

    public void comeBack(TTypedElement typedElement, int index) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.typedElementHelper.comeBack(typedElement, index);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#insetParameter(id=" + ((TModelElement)((Object)typedElement)).getId() + "#" + index + ")"));
    }

    public void reconnectTranstionSource(TTransition transition, TState newSourceState) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.reconnectTransitionSource(transition, newSourceState);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#reconnectTransitionSource(id=" + transition.getId() + "->target:" + newSourceState.getId() + ")"));
    }

    public void addState(TStateMachine stateMachine, TState state) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.addState(stateMachine, state);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addState(id=" + ((TModelElement)((Object)stateMachine)).getId() + "->" + state.getId() + ")"));
    }

    public void addFinalState(TStateMachine stateMachine, TFinalState state) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.addFinalState(stateMachine, state);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addFinalState(id=" + ((TModelElement)((Object)stateMachine)).getId() + "->" + state.getId() + ")"));
    }

    public void setInitialState(TStateMachine stateMachine, TInitialState state) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.setInitialState(stateMachine, state);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setInitialState(id=" + ((TModelElement)((Object)stateMachine)).getId() + "->" + state.getId() + ")"));
    }

    public void reconnectTranstionTarget(TTransition transition, TState newTargetState) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.reconnectTransitionTarget(transition, newTargetState);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateTransitionTarget(id=" + transition.getId() + "->target:" + newTargetState.getId() + ")"));
    }

    public void connectTransition(TStateMachine stateMachine, TTransition transition, TState source, TState target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.connectTransition(stateMachine, transition, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateTransition(id=source:" + transition.getId() + ":" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void addTransition(TStateMachine stateMachine, TTransition transition) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.addTransition(stateMachine, transition);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#addTransition(id=" + ((TModelElement)((Object)stateMachine)).getId() + "->" + transition.getId() + ")"));
    }

    public void setGuardCondition(TTransition transition, TGuardCondition guard) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.setGuardCondition(transition, guard);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setGuardCondition(id=" + transition.getId() + "->" + guard.getId() + ")"));
    }

    public void setTransitionLabel(TTransition transition, TTransitionLabel label) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.setTransitionLabel(transition, label);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setTransitionLabel(id=" + transition.getId() + "->" + label.getId() + ")"));
    }

    public void setDecisionLabel(TDecision decision, TDecisionLabel label) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.setDecisionLabel(decision, label);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setDecisionLabel(id=" + decision.getId() + "->" + label.getId() + ")"));
    }

    public void setTransitionSource(TTransition transition, TState source) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.setTransitionSource(transition, source);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setTransitionSource(id=" + transition.getId() + "->source:" + source.getId() + ")"));
    }

    public void setTransitionTarget(TTransition transition, TState target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.stateDocumentHelper.setTransitionTarget(transition, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setTransitionTarget(id=" + transition.getId() + "->target:" + target.getId() + ")"));
    }

    public void connectLink(TObjectModel objectModel, TLink link, TLinkSource source, TInstance target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.connectLink(objectModel, link, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=source:" + link.getId() + ":" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void reconnectLinkSource(TLink link, TLinkSource source) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.reconnectLinkSource(link, source);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + link.getId() + "->source:" + source.getId() + ")"));
    }

    public void reconnectLinkTarget(TLink link, TInstance target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.reconnectLinkTarget(link, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + link.getId() + "->target:" + target.getId() + ")"));
    }

    public void setValue(TInstanceVariable instanceVariable, String value) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.setName(instanceVariable.getValue(), value);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + instanceVariable.getId() + "->" + value + ")"));
    }

    public void connectSequence(TSequenceModel sequenceModel, TMessage message, TSequenciableElement source, TSequenciableElement target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.sequenceDocumentHelper.connectSequence(sequenceModel, message, source, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#relateMessage(id=source:" + message.getId() + ":" + source.getId() + "<->target:" + target.getId() + ")"));
    }

    public void reconnectSequenceSource(TMessage sequence, TSequenciableElement source) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.sequenceDocumentHelper.reconnectSequenceSource(sequence, source);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setMessageSource(id=" + sequence.getId() + "->source:" + source.getId() + ")"));
    }

    public void reconnectSequenceTarget(TMessage sequence, TSequenciableElement target) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.sequenceDocumentHelper.reconnectSequenceTarget(sequence, target);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setMessageTarget(id=" + sequence.getId() + "->target:" + target.getId() + ")"));
    }

    public void setMessageLabel(TMessage message, TMessageLabel label) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.sequenceDocumentHelper.setMessage(message, label);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("TDocument#setMessage(id=" + message.getId() + "->" + label.getId() + ")"));
    }

    public void addInstanceVariable(TInstance instance, TInstanceVariable variable) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.addInstanceVariable(instance, variable);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + instance.getId() + "->" + variable.getId() + ")"));
    }

    public void moveUpInstanceVariable(TInstance instance, TInstanceVariable variable) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.moveUpInstanceVariable(instance, variable);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + instance.getId() + "->" + variable.getId() + ")"));
    }

    public void moveDownInstanceVariable(TInstance instance, TInstanceVariable variable) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.moveDownInstanceVariable(instance, variable);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + instance.getId() + "->" + variable.getId() + ")"));
    }

    public void insertInstanceVariable(TInstance instance, TInstanceVariable variable, int index) {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_BEFORE);
        }
        this.objectDocumentHelper.insertInstanceVariable(instance, variable, index);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)VALIDATION_CHECK_MESSAGE_AFTER);
        }
        logger.info((Object)("(id=" + instance.getId() + "->" + variable.getId() + ")"));
    }

    public void readObject(XMLObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
    }

    public void writeObject(XMLObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
    }

    public String getTagName() {
        return DOCUMENT;
    }

    private boolean isValid() {
        return TDocumentVaidator.isVaild(this);
    }
}

