/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import trier.TrierException;
import trier.model.core.TClass;
import trier.model.core.TDocument;
import trier.model.core.TDocumentHelper;
import trier.model.core.TGeneralization;
import trier.model.core.TNamespace;

public class TGeneralizationDocumentHelper
extends TDocumentHelper {
    private static final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TGeneralizationDocumentHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.core.TGeneralizationDocumentHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    protected TGeneralizationDocumentHelper(TDocument document) {
        super(document);
    }

    public void relateGeneralization(TNamespace namespace, TGeneralization generalization, TClass child, TClass parent) {
        if (!$assertionsDisabled && generalization.getChildClass() != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        Iterator i = parent.getReferedGeneralizations().iterator();
        while (i.hasNext()) {
            TGeneralization referedGeneralization = (TGeneralization)i.next();
            if (!referedGeneralization.getParentClass().equals(parent) || !referedGeneralization.getChildClasses().contains(child)) continue;
            throw new TrierException("same generalization can't connect.Parent:" + parent + "Child:" + child);
        }
        super.addInstanceToModelCore(generalization);
        if (!generalization.getStereoType().getStereoTypedElements().contains(generalization)) {
            generalization.getStereoType().addStereoTypedElements(generalization);
        }
        generalization.setChildClass(child);
        child.addReferedGeneralization(generalization);
        generalization.setParentClass(parent);
        parent.addReferedGeneralization(generalization);
        generalization.setNamespace(namespace);
        namespace.addOwnedElement(generalization);
        if (!$assertionsDisabled && !child.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !parent.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() != parent) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClass() != child) {
            throw new AssertionError();
        }
    }

    public void setChild(TGeneralization generalization, TClass childClass) {
        if (!$assertionsDisabled && childClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClass() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() == null) {
            throw new AssertionError();
        }
        List oldChildren = generalization.getChildClasses();
        Iterator i = oldChildren.iterator();
        while (i.hasNext()) {
            TClass oldChild = (TClass)i.next();
            oldChild.removeReferedGeneralization(generalization);
            if (!$assertionsDisabled && oldChild.getReferedGeneralizations().contains(generalization)) {
                throw new AssertionError();
            }
        }
        childClass.addReferedGeneralization(generalization);
        generalization.setChildClass(childClass);
        if (!$assertionsDisabled && !childClass.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClass() != childClass) {
            throw new AssertionError();
        }
    }

    public void setChildren(TGeneralization generalization, List children) {
        List oldChildren = generalization.getChildClasses();
        Iterator i = oldChildren.iterator();
        while (i.hasNext()) {
            TClass oldChild = (TClass)i.next();
            oldChild.removeReferedGeneralization(generalization);
            if (!$assertionsDisabled && oldChild.getReferedGeneralizations().contains(generalization)) {
                throw new AssertionError();
            }
        }
        List childClasses = generalization.getChildClasses();
        i = childClasses.iterator();
        while (i.hasNext()) {
            TClass childClass = (TClass)i.next();
            childClass.addReferedGeneralization(generalization);
            if (!$assertionsDisabled && !childClass.getReferedGeneralizations().contains(generalization)) {
                throw new AssertionError();
            }
        }
        generalization.setChildClasses(childClasses);
    }

    public void setParent(TGeneralization generalization, TClass parentClass) {
        if (!$assertionsDisabled && parentClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClass() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() == null) {
            throw new AssertionError();
        }
        TClass oldParent = generalization.getParentClass();
        if (oldParent != parentClass) {
            if (oldParent != null) {
                oldParent.removeReferedGeneralization(generalization);
            }
            parentClass.addReferedGeneralization(generalization);
            generalization.setParentClass(parentClass);
        }
        if (!$assertionsDisabled && oldParent.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !parentClass.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() != parentClass) {
            throw new AssertionError();
        }
    }

    public void addChild(TGeneralization generalization, TClass childClass) {
        if (!$assertionsDisabled && childClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClass() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() == null) {
            throw new AssertionError();
        }
        childClass.addReferedGeneralization(generalization);
        generalization.addChildClass(childClass);
        if (!$assertionsDisabled && !childClass.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !generalization.getChildClasses().contains(childClass)) {
            throw new AssertionError();
        }
    }

    public void removeChild(TGeneralization generalization, TClass childClass) {
        if (!$assertionsDisabled && childClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClass() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getParentClass() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && generalization.getChildClasses().size() <= 1) {
            throw new AssertionError();
        }
        childClass.addReferedGeneralization(generalization);
        generalization.removeChildClass(childClass);
        if (!$assertionsDisabled && !childClass.getReferedGeneralizations().contains(generalization)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !generalization.getChildClasses().contains(childClass)) {
            throw new AssertionError();
        }
    }

    protected void checkIsValidGeneralization(TClass parent, TClass child) {
        if (parent != null && child != null && child.isInterface() && !parent.isInterface()) {
            throw new TrierException("Invalid parent and child.parent:" + parent.toString() + " child:" + child.toString());
        }
    }
}

