/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import trier.model.core.TClass;
import trier.model.core.TClassifier;
import trier.model.core.TFeature;
import trier.model.core.TMetaClass;
import trier.model.core.TParameter;
import trier.model.core.TTypedElement;
import trier.model.core.TTypedElementAdapterImpl;

public class TMethod
extends TFeature
implements TTypedElement {
    private static final Logger logger;
    private List parameters = new ArrayList();
    private TTypedElementAdapterImpl typedElementAdapter = new TTypedElementAdapterImpl();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected TMethod(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    protected void remove() {
        super.remove();
        TClass owner = this.getOwner();
        if (owner.getMethods().contains(this)) {
            owner.removeMethod(this);
        }
        this.getType().removeTypedElement(this);
        this.removeElements(this.getParameters());
    }

    protected void comeBack() {
        super.comeBack();
        TClass owner = this.getOwner();
        if (!owner.getMethods().contains(this)) {
            owner.addMethod(this);
        }
        this.getType().addTypedElement(this);
        this.comeBackElements(this.getParameters());
    }

    protected void comeBack(int index) {
        super.comeBack();
        TClass owner = this.getOwner();
        if (!owner.getMethods().contains(this)) {
            owner.insertMethod(this, index);
        }
        this.getType().addTypedElement(this);
        this.comeBackElements(this.getParameters());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getVisibilityKind().getSign()) + " ");
        buffer.append(this.getName());
        buffer.append(" (");
        Iterator i = this.getParameters().iterator();
        while (i.hasNext()) {
            buffer.append(i.next().toString());
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (!this.getType().isNull()) {
            buffer.append(" : " + this.getType().getName());
        }
        return buffer.toString();
    }

    public List getModelChildren() {
        ArrayList<TParameter> children = new ArrayList<TParameter>();
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            TParameter parameter = (TParameter)i.next();
            children.add(parameter);
            children.addAll(parameter.getModelChildren());
        }
        return children;
    }

    protected void addParameter(TParameter parameter) {
        this.parameters.add(parameter);
        this.fireStructureChange("TModelElement changed");
    }

    protected void insertParameter(TParameter parameter, int index) {
        this.parameters.add(index, parameter);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeParameter(TParameter parameter) {
        this.parameters.remove(parameter);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveUpParameter(TParameter parameter) {
        this.moveParameter(parameter, -1);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveDownParameter(TParameter parameter) {
        this.moveParameter(parameter, 1);
        this.fireStructureChange("TModelElement changed");
    }

    private void moveParameter(TParameter parameter, int direction) {
        int oldIndex = this.parameters.indexOf(parameter);
        int newIndex = oldIndex + direction;
        TParameter temp = (TParameter)this.parameters.get(newIndex);
        this.parameters.set(newIndex, parameter);
        this.parameters.set(oldIndex, temp);
    }

    public List getParameters() {
        return new ArrayList(this.parameters);
    }

    public TClassifier getType() {
        return this.typedElementAdapter.getType();
    }

    protected void setType(TClassifier classifier) {
        TClassifier oldType = this.typedElementAdapter.getType();
        this.typedElementAdapter.setType(classifier);
        super.firePropertyChange("TModelElement changed", (Object)oldType, (Object)classifier);
    }

    public String getElementType() {
        return "Method";
    }

    public String getTagName() {
        return "Method";
    }
}

