/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectInputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectOutputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLSerializable;
import jp.ac.keio.sfc.crew.model.ModelObject;
import org.apache.log4j.Logger;
import trier.model.core.TAnchor;
import trier.model.core.TElement;
import trier.model.core.TMetaClass;
import trier.model.core.TNamespace;
import trier.model.core.TStereoType;

public abstract class TModelElement
extends ModelObject
implements TElement,
XMLSerializable {
    private static final Logger logger;
    private TMetaClass $metaClass;
    private String id;
    private String name = "";
    private TNamespace $namespace;
    private TStereoType $stereoType;
    private List $anchors = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.core.TModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    protected TModelElement(TMetaClass metaClass, String id) {
        this.$metaClass = metaClass;
        this.id = id;
    }

    protected void remove() {
        if (!$assertionsDisabled && !this.isNull() && this.getMetaClass().isRemoved(this)) {
            throw new AssertionError();
        }
        if (!this.isRemoved() && !this.isNull()) {
            this.getMetaClass().removeInstance(this);
            if (this.getStereoType() != null) {
                this.getStereoType().removeStereoTypedElements(this);
            }
            if (this.getNamespace() != null) {
                this.getNamespace().removeOwnedElement(this);
            }
            this.removeElements(this.$anchors);
        }
    }

    protected void comeBack() {
        if (!($assertionsDisabled || this.isNull() || this.isRemoved())) {
            throw new AssertionError();
        }
        if (this.isRemoved() && !this.isNull()) {
            this.getMetaClass().addInstance(this);
            if (this.getStereoType() != null) {
                this.getStereoType().addStereoTypedElements(this);
            }
            if (this.getNamespace() != null) {
                this.getNamespace().addOwnedElement(this);
            }
            this.comeBackElements(this.$anchors);
        }
    }

    public boolean isNull() {
        return this.id.startsWith("NullObject");
    }

    public boolean equals(Object o) {
        if (!(o instanceof TModelElement)) {
            return false;
        }
        return this.getId() == ((TModelElement)o).getId();
    }

    public boolean isRemoved() {
        return !this.$metaClass.getAllInstances().contains(this);
    }

    public List getModelChildren() {
        return new ArrayList();
    }

    public void addModelEventListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void removeModelEventListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }

    public String getId() {
        if (this.id.equals("NullObject")) {
            this.id = "NullObject_" + this.getMetaClass().getName();
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TNamespace getNamespace() {
        return this.$namespace;
    }

    public TStereoType getStereoType() {
        return this.$stereoType;
    }

    public TMetaClass getMetaClass() {
        return this.$metaClass;
    }

    protected void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("TModelElement changed", oldName, name);
    }

    protected void setNamespace(TNamespace namespace) {
        TNamespace oldNamespace = this.$namespace;
        this.$namespace = namespace;
        this.firePropertyChange("TModelElement changed", oldNamespace, namespace);
    }

    protected void setStereoType(TStereoType stereoType) {
        TStereoType oldStereoType = this.$stereoType;
        this.$stereoType = stereoType;
        this.firePropertyChange("TModelElement changed", oldStereoType, stereoType);
    }

    protected void addReferedAnchor(TAnchor anchor) {
        this.$anchors.add(anchor);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeReferedAnchor(TAnchor anchor) {
        this.$anchors.remove(anchor);
        this.fireStructureChange("TModelElement changed");
    }

    public Collection getReferedAnchors() {
        TreeSet anchors = new TreeSet();
        Iterator i = this.$anchors.iterator();
        while (i.hasNext()) {
            anchors.add(i.next());
        }
        return anchors;
    }

    protected void removeElements(Collection elements) {
        Iterator i = new ArrayList(elements).iterator();
        while (i.hasNext()) {
            TModelElement element = (TModelElement)i.next();
            if (element.isRemoved()) continue;
            element.remove();
        }
    }

    protected void comeBackElements(Collection elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            TModelElement element = (TModelElement)i.next();
            if (!element.isRemoved()) continue;
            element.comeBack();
        }
    }

    public void readObject(XMLObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        if (!this.isNull() && this.getMetaClass() != null) {
            this.getMetaClass().addInstance(this);
        }
        if (!this.isNull() && this.getStereoType() != null) {
            this.getStereoType().addStereoTypedElements(this);
        }
    }

    public void writeObject(XMLObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
    }
}

