/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.serialize.xml;

import org.apache.log4j.Logger;
import trier.model.core.TAggregationKind;
import trier.model.core.TAssociationEnd;
import trier.model.core.TClass;
import trier.model.core.TDocument;
import trier.model.core.TMultiplicity;
import trier.model.core.TRole;
import trier.model.core.serialize.xml.IXModelElement;
import trier.model.core.serialize.xml.TXFeatureBridge;
import trier.model.core.serialize.xml.TXMultiplicityBridge;
import trier.model.core.serialize.xml.TXRoleBridge;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.XAssociationEnd;
import trier.util.EIdMap;

public class TXAssociationEndBridge
extends TXFeatureBridge {
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    private static final Logger logger;
    private TXRoleBridge roleBridge;
    private TXMultiplicityBridge multiplicityBridge;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.serialize.xml.TXAssociationEndBridge");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected TXAssociationEndBridge(TDocument document, Object model, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, xmlElement, idMap, factory);
    }

    protected TXAssociationEndBridge(TDocument document, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, document.createAssociationEnd(((IXModelElement)xmlElement).getId()), xmlElement, idMap, factory);
    }

    protected TXAssociationEndBridge(TDocument document, Object model, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, factory.createXAssociationEnd(), idMap, factory);
    }

    public void buildXML() {
        super.buildXML();
        TAssociationEnd tAssociationEnd = this.getTAssociationEnd();
        XAssociationEnd xAssociationEnd = this.getXAssociationEnd();
        if (!tAssociationEnd.getRole().isNull()) {
            TXRoleBridge roleBridge = (TXRoleBridge)super.create(tAssociationEnd.getRole());
            roleBridge.buildXML();
            xAssociationEnd.setRole(roleBridge.getXRole());
        }
        if (!tAssociationEnd.getMultiplicity().isNull()) {
            TXMultiplicityBridge multiplicityBridge = (TXMultiplicityBridge)super.create(tAssociationEnd.getMultiplicity());
            multiplicityBridge.buildXML();
            xAssociationEnd.setMultiplicity(multiplicityBridge.getXMultiplicity());
        }
        xAssociationEnd.setConnectionOwner(tAssociationEnd.getOwner().getId());
        xAssociationEnd.setAgggregation(tAssociationEnd.getAggregationKind().toString());
        xAssociationEnd.setNavigable(tAssociationEnd.isNavigable());
    }

    public void buildStructure() {
        super.buildStructure();
        TAssociationEnd tAssociationEnd = this.getTAssociationEnd();
        XAssociationEnd xAssociationEnd = this.getXAssociationEnd();
        if (xAssociationEnd.getRole() != null) {
            this.roleBridge = (TXRoleBridge)super.create(xAssociationEnd.getRole());
            this.roleBridge.buildStructure();
            this.getDocument().setRole(tAssociationEnd, this.roleBridge.getTRole());
        } else {
            this.getDocument().setRole(tAssociationEnd, (TRole)this.getDocument().getModelCore().getTRoleClass().getNullObject());
        }
        if (xAssociationEnd.getMultiplicity() != null) {
            this.multiplicityBridge = (TXMultiplicityBridge)super.create(xAssociationEnd.getMultiplicity());
            this.multiplicityBridge.buildStructure();
            this.getDocument().setMultiplicity(tAssociationEnd, this.multiplicityBridge.getTMultiplicity());
        } else {
            this.getDocument().setMultiplicity(tAssociationEnd, (TMultiplicity)this.getDocument().getModelCore().getTMultiplicityClass().getNullObject());
        }
        TAggregationKind aggregationKind = TAggregationKind.getAggregationKind(xAssociationEnd.getAgggregation());
        this.getDocument().setAggregationKind(tAssociationEnd, aggregationKind);
        this.getDocument().setNavigable(tAssociationEnd, xAssociationEnd.getNavigable());
    }

    public void buildReference() {
        TClass owner = (TClass)this.getDocument().getTElement(this.getXAssociationEnd().getConnectionOwner());
        this.getDocument().setOwner(this.getTAssociationEnd(), owner);
        if (this.multiplicityBridge != null) {
            this.multiplicityBridge.buildReference();
        } else {
            this.getDocument().setMultiplicity(this.getTAssociationEnd(), (TMultiplicity)this.getDocument().getModelCore().getTMultiplicityClass().getNullObject());
        }
        if (this.roleBridge != null) {
            this.roleBridge.buildReference();
        } else {
            this.getDocument().setRole(this.getTAssociationEnd(), (TRole)this.getDocument().getModelCore().getTRoleClass().getNullObject());
        }
    }

    protected void setConnectionType(String type) {
        this.getXAssociationEnd().setConnectionType(type);
    }

    public XAssociationEnd getXAssociationEnd() {
        return (XAssociationEnd)this.getXmlElement();
    }

    public TAssociationEnd getTAssociationEnd() {
        return (TAssociationEnd)this.getModel();
    }
}

