/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.serialize.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import trier.model.core.TAttribute;
import trier.model.core.TClass;
import trier.model.core.TDocument;
import trier.model.core.TMethod;
import trier.model.core.TModifier;
import trier.model.core.TVisibilityKind;
import trier.model.core.serialize.xml.IXModelElement;
import trier.model.core.serialize.xml.IXModifiedElement;
import trier.model.core.serialize.xml.TXAttributeBridge;
import trier.model.core.serialize.xml.TXClassifierBridge;
import trier.model.core.serialize.xml.TXMethodBridge;
import trier.model.core.serialize.xml.TXModelElementBridge;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.XAttribute;
import trier.model.core.xml.XClass;
import trier.model.core.xml.XMethod;
import trier.util.EIdMap;

public class TXClassBridge
extends TXClassifierBridge {
    private static final Logger logger;
    private List methodBridges = new ArrayList();
    private List attributeBridges = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.serialize.xml.TXClassBridge");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected TXClassBridge(TDocument document, Object model, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, xmlElement, idMap, factory);
    }

    protected TXClassBridge(TDocument document, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, document.createClass(((IXModelElement)xmlElement).getName(), ((IXModelElement)xmlElement).getId()), xmlElement, idMap, factory);
    }

    protected TXClassBridge(TDocument document, Object model, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, factory.createXClass(), idMap, factory);
    }

    public void buildXML() {
        super.buildXML();
        TClass tClass = this.getTClass();
        XClass xClass = this.getXClass();
        TModifier tModifier = tClass.getModifier();
        IXModifiedElement xModifiedElement = this.getXClass();
        xModifiedElement.setIsAbstract(tModifier.isAbstract());
        xModifiedElement.setIsStatic(tModifier.isStatic());
        xModifiedElement.setVisibility(tModifier.getVisibility().toString());
        xModifiedElement.setIsFinal(tModifier.isFinal());
        xClass.setIsInterface(tClass.isInterface());
        Iterator i = tClass.getMethods().iterator();
        while (i.hasNext()) {
            TMethod tMethod = (TMethod)i.next();
            TXMethodBridge methodBridge = (TXMethodBridge)super.create(tMethod);
            methodBridge.buildXML();
            this.addMethod(methodBridge);
        }
        i = tClass.getAttributes().iterator();
        while (i.hasNext()) {
            TAttribute tAtribute = (TAttribute)i.next();
            TXAttributeBridge attributeBridge = (TXAttributeBridge)super.create(tAtribute);
            attributeBridge.buildXML();
            this.addAttribute(attributeBridge);
        }
    }

    public void buildStructure() {
        super.buildStructure();
        TClass tClass = this.getTClass();
        XClass xClass = this.getXClass();
        this.getDocument().setAbstract(tClass, xClass.getIsAbstract());
        this.getDocument().setStatic(tClass, xClass.getIsStatic());
        TVisibilityKind visibility = TVisibilityKind.getVisibilityKind(xClass.getVisibility());
        this.getDocument().setVisibility(tClass, visibility);
        this.getDocument().setFinal(tClass, xClass.getIsFinal());
        this.getDocument().setInterface(tClass, xClass.getIsInterface());
        XMethod[] xMethods = xClass.getMethod();
        int i = 0;
        while (i < xMethods.length) {
            TXMethodBridge methodBridge = (TXMethodBridge)super.create(xMethods[i]);
            methodBridge.buildStructure();
            this.methodBridges.add(methodBridge);
            this.getDocument().addMethod(this.getTClass(), methodBridge.getTMethod());
            ++i;
        }
        XAttribute[] xAttributes = xClass.getAttribute();
        int i2 = 0;
        while (i2 < xAttributes.length) {
            TXAttributeBridge attributeBridge = (TXAttributeBridge)super.create(xAttributes[i2]);
            attributeBridge.buildStructure();
            this.attributeBridges.add(attributeBridge);
            this.getDocument().addAttribute(this.getTClass(), attributeBridge.getTAttribute());
            ++i2;
        }
    }

    public void buildReference() {
        super.buildReference();
        ArrayList allBridges = new ArrayList(this.methodBridges);
        allBridges.addAll(this.attributeBridges);
        Iterator i = allBridges.iterator();
        while (i.hasNext()) {
            TXModelElementBridge bridge = (TXModelElementBridge)i.next();
            bridge.buildReference();
        }
    }

    private void addMethod(TXMethodBridge methodBridge) {
        this.getXClass().addMethod(methodBridge.getXMethod());
    }

    private void addAttribute(TXAttributeBridge attributeBridge) {
        this.getXClass().addAttribute(attributeBridge.getXAttribute());
    }

    public XClass getXClass() {
        return (XClass)this.getXmlElement();
    }

    public TClass getTClass() {
        return (TClass)this.getModel();
    }
}

