/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.serialize.xml;

import trier.model.core.TDocument;
import trier.model.core.TFeature;
import trier.model.core.TModifier;
import trier.model.core.TVisibilityKind;
import trier.model.core.serialize.xml.IXModifiedElement;
import trier.model.core.serialize.xml.TXModelElementBridge;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.util.EIdMap;

public abstract class TXFeatureBridge
extends TXModelElementBridge {
    public TXFeatureBridge(TDocument document, Object model, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, xmlElement, idMap, factory);
    }

    public void buildXML() {
        super.buildXML();
        TFeature tFeature = this.getTFeature();
        TModifier tModifier = tFeature.getModifier();
        IXModifiedElement xModifiedElement = this.getXModifiedElement();
        xModifiedElement.setIsAbstract(tModifier.isAbstract());
        xModifiedElement.setIsStatic(tModifier.isStatic());
        xModifiedElement.setVisibility(tModifier.getVisibility().toString());
        xModifiedElement.setIsFinal(tModifier.isFinal());
    }

    public void buildStructure() {
        super.buildStructure();
        TFeature tFeature = this.getTFeature();
        IXModifiedElement xFeature = this.getXModifiedElement();
        tFeature.getModifier();
        this.getDocument().setAbstract(tFeature, xFeature.getIsAbstract());
        this.getDocument().setStatic(tFeature, xFeature.getIsStatic());
        TVisibilityKind visibility = TVisibilityKind.getVisibilityKind(xFeature.getVisibility());
        this.getDocument().setVisibility(tFeature, visibility);
        this.getDocument().setFinal(tFeature, xFeature.getIsFinal());
    }

    public TFeature getTFeature() {
        return (TFeature)this.getModel();
    }

    public IXModifiedElement getXModifiedElement() {
        return (IXModifiedElement)this.getXmlElement();
    }
}

