/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XModelCore;
import trier.model.core.xml.XPackage;

public class XDocument
implements Serializable,
Cloneable,
IRNode {
    private XModelCore modelCore_;
    private XPackage package_;
    private IRNode parentRNode_;

    public XDocument() {
    }

    public XDocument(XDocument source) {
        this.setup(source);
    }

    public XDocument(RStack stack) {
        this.setup(stack);
    }

    public XDocument(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XDocument(Element element) {
        this.setup(element);
    }

    public XDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XDocument(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XDocument(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XDocument(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XDocument(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XDocument source) {
        this.setModelCore(source.getModelCore());
        this.setPackage(source.getPackage());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        RStack stack = new RStack(element);
        if (XModelCore.isMatch(stack)) {
            this.setModelCore(factory.createXModelCore(stack));
        }
        if (XPackage.isMatch(stack)) {
            this.setPackage(factory.createXPackage(stack));
        }
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXDocument(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("Document");
        if (this.modelCore_ != null) {
            this.modelCore_.makeElement(element);
        }
        if (this.package_ != null) {
            this.package_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XModelCore getModelCore() {
        return this.modelCore_;
    }

    public final void setModelCore(XModelCore modelCore) {
        this.modelCore_ = modelCore;
        if (modelCore != null) {
            modelCore.rSetParentRNode(this);
        }
    }

    public final XPackage getPackage() {
        return this.package_;
    }

    public final void setPackage(XPackage packageValue) {
        this.package_ = packageValue;
        if (packageValue != null) {
            packageValue.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<Document");
        buffer.append(">");
        if (this.modelCore_ != null) {
            this.modelCore_.makeTextElement(buffer);
        }
        if (this.package_ != null) {
            this.package_.makeTextElement(buffer);
        }
        buffer.append("</Document>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<Document");
        buffer.write(">");
        if (this.modelCore_ != null) {
            this.modelCore_.makeTextElement(buffer);
        }
        if (this.package_ != null) {
            this.package_.makeTextElement(buffer);
        }
        buffer.write("</Document>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<Document");
        buffer.print(">");
        if (this.modelCore_ != null) {
            this.modelCore_.makeTextElement(buffer);
        }
        if (this.package_ != null) {
            this.package_.makeTextElement(buffer);
        }
        buffer.print("</Document>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.modelCore_ != null) {
            classNodes.add(this.modelCore_);
        }
        if (this.package_ != null) {
            classNodes.add(this.package_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "Document")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XModelCore.isMatchHungry(target)) {
            return false;
        }
        if (!XPackage.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XDocument.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XDocument.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

