/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.serialize.xml.IXModelElement;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XGeneralizationChild;
import trier.model.core.xml.XGeneralizationParent;

public class XGeneralization
implements Serializable,
Cloneable,
IXModelElement,
IRNode {
    private String id_;
    private String name_;
    private String typedStereoType_;
    private XGeneralizationParent generalizationParent_;
    private List generalizationChild_ = new ArrayList();
    private IRNode parentRNode_;

    public XGeneralization() {
        this.id_ = "";
    }

    public XGeneralization(XGeneralization source) {
        this.setup(source);
    }

    public XGeneralization(RStack stack) {
        this.setup(stack);
    }

    public XGeneralization(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XGeneralization(Element element) {
        this.setup(element);
    }

    public XGeneralization(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XGeneralization(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XGeneralization(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XGeneralization(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XGeneralization(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XGeneralization(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XGeneralization source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setTypedStereoType(source.getTypedStereoType());
        this.setGeneralizationParent(source.getGeneralizationParent());
        this.generalizationChild_.clear();
        int size = source.generalizationChild_.size();
        int i = 0;
        while (i < size) {
            this.addGeneralizationChild((XGeneralizationChild)source.getGeneralizationChild(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.typedStereoType_ = URelaxer.getAttributePropertyAsString(element, "typedStereoType");
        if (XGeneralizationParent.isMatch(stack)) {
            this.setGeneralizationParent(factory.createXGeneralizationParent(stack));
        }
        this.generalizationChild_.clear();
        while (XGeneralizationChild.isMatch(stack)) {
            this.addGeneralizationChild(factory.createXGeneralizationChild(stack));
        }
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXGeneralization(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("Generalization");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.typedStereoType_ != null) {
            URelaxer.setAttributePropertyByString(element, "typedStereoType", this.typedStereoType_);
        }
        if (this.generalizationParent_ != null) {
            this.generalizationParent_.makeElement(element);
        }
        int size = this.generalizationChild_.size();
        int i = 0;
        while (i < size) {
            XGeneralizationChild value = (XGeneralizationChild)this.generalizationChild_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getTypedStereoType() {
        return this.typedStereoType_;
    }

    public final void setTypedStereoType(String typedStereoType) {
        this.typedStereoType_ = typedStereoType;
    }

    public final XGeneralizationParent getGeneralizationParent() {
        return this.generalizationParent_;
    }

    public final void setGeneralizationParent(XGeneralizationParent generalizationParent) {
        this.generalizationParent_ = generalizationParent;
        if (generalizationParent != null) {
            generalizationParent.rSetParentRNode(this);
        }
    }

    public final XGeneralizationChild[] getGeneralizationChild() {
        XGeneralizationChild[] array = new XGeneralizationChild[this.generalizationChild_.size()];
        return this.generalizationChild_.toArray(array);
    }

    public final void setGeneralizationChild(XGeneralizationChild[] generalizationChild) {
        this.generalizationChild_.clear();
        int i = 0;
        while (i < generalizationChild.length) {
            this.addGeneralizationChild(generalizationChild[i]);
            ++i;
        }
        i = 0;
        while (i < generalizationChild.length) {
            generalizationChild[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setGeneralizationChild(XGeneralizationChild generalizationChild) {
        this.generalizationChild_.clear();
        this.addGeneralizationChild(generalizationChild);
        if (generalizationChild != null) {
            generalizationChild.rSetParentRNode(this);
        }
    }

    public final void addGeneralizationChild(XGeneralizationChild generalizationChild) {
        this.generalizationChild_.add(generalizationChild);
        if (generalizationChild != null) {
            generalizationChild.rSetParentRNode(this);
        }
    }

    public final void addGeneralizationChild(XGeneralizationChild[] generalizationChild) {
        int i = 0;
        while (i < generalizationChild.length) {
            this.addGeneralizationChild(generalizationChild[i]);
            ++i;
        }
        i = 0;
        while (i < generalizationChild.length) {
            generalizationChild[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeGeneralizationChild() {
        return this.generalizationChild_.size();
    }

    public final XGeneralizationChild getGeneralizationChild(int index) {
        return (XGeneralizationChild)this.generalizationChild_.get(index);
    }

    public final void setGeneralizationChild(int index, XGeneralizationChild generalizationChild) {
        this.generalizationChild_.set(index, generalizationChild);
    }

    public final void addGeneralizationChild(int index, XGeneralizationChild generalizationChild) {
        this.generalizationChild_.add(index, generalizationChild);
    }

    public final void removeGeneralizationChild(int index) {
        this.generalizationChild_.remove(index);
    }

    public final void removeGeneralizationChild(XGeneralizationChild generalizationChild) {
        this.generalizationChild_.remove(generalizationChild);
    }

    public final void clearGeneralizationChild() {
        this.generalizationChild_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<Generalization");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.append(" typedStereoType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.generalizationParent_ != null) {
            this.generalizationParent_.makeTextElement(buffer);
        }
        int size = this.generalizationChild_.size();
        int i = 0;
        while (i < size) {
            XGeneralizationChild value = (XGeneralizationChild)this.generalizationChild_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</Generalization>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<Generalization");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.write(" typedStereoType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.generalizationParent_ != null) {
            this.generalizationParent_.makeTextElement(buffer);
        }
        int size = this.generalizationChild_.size();
        int i = 0;
        while (i < size) {
            XGeneralizationChild value = (XGeneralizationChild)this.generalizationChild_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</Generalization>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<Generalization");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.print(" typedStereoType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.generalizationParent_ != null) {
            this.generalizationParent_.makeTextElement(buffer);
        }
        int size = this.generalizationChild_.size();
        int i = 0;
        while (i < size) {
            XGeneralizationChild value = (XGeneralizationChild)this.generalizationChild_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</Generalization>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypedStereoTypeAsString() {
        return URelaxer.getString(this.getTypedStereoType());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypedStereoTypeByString(String string) {
        this.setTypedStereoType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<XGeneralizationParent> classNodes = new ArrayList<XGeneralizationParent>();
        if (this.generalizationParent_ != null) {
            classNodes.add(this.generalizationParent_);
        }
        classNodes.addAll(this.generalizationChild_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "Generalization")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        XGeneralizationParent.isMatchHungry(target);
        while (XGeneralizationChild.isMatchHungry(target)) {
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XGeneralization.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XGeneralization.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

