/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XMetaClass;

public class XModelCore
implements Serializable,
Cloneable,
IRNode {
    private List metaClass_ = new ArrayList();
    private IRNode parentRNode_;

    public XModelCore() {
    }

    public XModelCore(XModelCore source) {
        this.setup(source);
    }

    public XModelCore(RStack stack) {
        this.setup(stack);
    }

    public XModelCore(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XModelCore(Element element) {
        this.setup(element);
    }

    public XModelCore(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XModelCore(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XModelCore(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XModelCore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XModelCore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XModelCore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XModelCore source) {
        this.metaClass_.clear();
        int size = source.metaClass_.size();
        int i = 0;
        while (i < size) {
            this.addMetaClass((XMetaClass)source.getMetaClass(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        RStack stack = new RStack(element);
        this.metaClass_.clear();
        while (XMetaClass.isMatch(stack)) {
            this.addMetaClass(factory.createXMetaClass(stack));
        }
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXModelCore(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("ModelCore");
        int size = this.metaClass_.size();
        int i = 0;
        while (i < size) {
            XMetaClass value = (XMetaClass)this.metaClass_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XMetaClass[] getMetaClass() {
        XMetaClass[] array = new XMetaClass[this.metaClass_.size()];
        return this.metaClass_.toArray(array);
    }

    public final void setMetaClass(XMetaClass[] metaClass) {
        this.metaClass_.clear();
        int i = 0;
        while (i < metaClass.length) {
            this.addMetaClass(metaClass[i]);
            ++i;
        }
        i = 0;
        while (i < metaClass.length) {
            metaClass[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setMetaClass(XMetaClass metaClass) {
        this.metaClass_.clear();
        this.addMetaClass(metaClass);
        if (metaClass != null) {
            metaClass.rSetParentRNode(this);
        }
    }

    public final void addMetaClass(XMetaClass metaClass) {
        this.metaClass_.add(metaClass);
        if (metaClass != null) {
            metaClass.rSetParentRNode(this);
        }
    }

    public final void addMetaClass(XMetaClass[] metaClass) {
        int i = 0;
        while (i < metaClass.length) {
            this.addMetaClass(metaClass[i]);
            ++i;
        }
        i = 0;
        while (i < metaClass.length) {
            metaClass[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeMetaClass() {
        return this.metaClass_.size();
    }

    public final XMetaClass getMetaClass(int index) {
        return (XMetaClass)this.metaClass_.get(index);
    }

    public final void setMetaClass(int index, XMetaClass metaClass) {
        this.metaClass_.set(index, metaClass);
    }

    public final void addMetaClass(int index, XMetaClass metaClass) {
        this.metaClass_.add(index, metaClass);
    }

    public final void removeMetaClass(int index) {
        this.metaClass_.remove(index);
    }

    public final void removeMetaClass(XMetaClass metaClass) {
        this.metaClass_.remove(metaClass);
    }

    public final void clearMetaClass() {
        this.metaClass_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<ModelCore");
        buffer.append(">");
        int size = this.metaClass_.size();
        int i = 0;
        while (i < size) {
            XMetaClass value = (XMetaClass)this.metaClass_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</ModelCore>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<ModelCore");
        buffer.write(">");
        int size = this.metaClass_.size();
        int i = 0;
        while (i < size) {
            XMetaClass value = (XMetaClass)this.metaClass_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</ModelCore>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<ModelCore");
        buffer.print(">");
        int size = this.metaClass_.size();
        int i = 0;
        while (i < size) {
            XMetaClass value = (XMetaClass)this.metaClass_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</ModelCore>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.metaClass_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "ModelCore")) {
            return false;
        }
        RStack target = new RStack(element);
        while (XMetaClass.isMatchHungry(target)) {
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XModelCore.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XModelCore.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

