/*
 * Decompiled with CFR 0.152.
 */
package trier.model.object;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import trier.model.core.TMetaClass;
import trier.model.core.TModelElement;
import trier.model.object.TInstanceVariable;
import trier.model.object.TLink;
import trier.model.object.TLinkSource;

public class TInstance
extends TModelElement
implements TLinkSource {
    private List $links = new ArrayList();
    private List variables = new ArrayList();
    private boolean table = false;

    protected TInstance(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    protected void remove() {
        super.remove();
        if (!this.isNull()) {
            this.removeElements(this.getLinks());
            this.removeElements(this.getVariables());
        }
    }

    protected void comeBack() {
        super.comeBack();
        if (!this.isNull()) {
            this.comeBackElements(this.getLinks());
            this.comeBackElements(this.getVariables());
        }
    }

    public List getModelChildren() {
        List children = super.getModelChildren();
        Iterator i = this.variables.iterator();
        while (i.hasNext()) {
            TModelElement element = (TModelElement)i.next();
            children.add(element);
            children.addAll(element.getModelChildren());
        }
        return children;
    }

    public List getLinks() {
        return new ArrayList(this.$links);
    }

    public void removeLink(TLink sequence) {
        this.$links.remove(sequence);
        this.fireStructureChange("TModelElement changed");
    }

    public void addLink(TLink sequence) {
        this.$links.add(sequence);
        this.fireStructureChange("TModelElement changed");
    }

    public List getVariables() {
        return new ArrayList(this.variables);
    }

    protected void addVariable(TInstanceVariable variable) {
        this.variables.add(variable);
        this.fireStructureChange("TModelElement changed");
    }

    protected void removeVariable(TInstanceVariable variable) {
        this.variables.remove(variable);
        this.fireStructureChange("TModelElement changed");
    }

    protected void insertVariable(TInstanceVariable variable, int index) {
        this.variables.add(index, variable);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveUpVariable(TInstanceVariable variable) {
        this.moveVariable(variable, -1);
        this.fireStructureChange("TModelElement changed");
    }

    protected void moveDownVariable(TInstanceVariable variable) {
        this.moveVariable(variable, 1);
        this.fireStructureChange("TModelElement changed");
    }

    private void moveVariable(TInstanceVariable variable, int direction) {
        int oldIndex = this.variables.indexOf(variable);
        int newIndex = oldIndex + direction;
        TInstanceVariable temp = (TInstanceVariable)this.variables.get(newIndex);
        this.variables.set(newIndex, variable);
        this.variables.set(oldIndex, temp);
    }

    public String getElementType() {
        return "Instance";
    }

    public String getTagName() {
        return "Instance";
    }

    public boolean isTable() {
        return this.table;
    }

    public void setTable(boolean b) {
        this.table = b;
    }

    public boolean hasArray() {
        Iterator i = this.getVariables().iterator();
        while (i.hasNext()) {
            TInstanceVariable element = (TInstanceVariable)i.next();
            if (!element.isArray()) continue;
            return true;
        }
        return false;
    }
}

