/*
 * Decompiled with CFR 0.152.
 */
package trier.model.state;

import trier.model.core.TDocument;
import trier.model.core.TModelElementDocumentHelper;
import trier.model.state.TDecision;
import trier.model.state.TDecisionLabel;
import trier.model.state.TFinalState;
import trier.model.state.TGuardCondition;
import trier.model.state.TInitialState;
import trier.model.state.TState;
import trier.model.state.TStateMachine;
import trier.model.state.TTransition;
import trier.model.state.TTransitionLabel;

public class TStateDocumentHelper
extends TModelElementDocumentHelper {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.state.TStateDocumentHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TStateDocumentHelper(TDocument document) {
        super(document);
    }

    public void addState(TStateMachine stateMachine, TState state) {
        if (!$assertionsDisabled && stateMachine == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (state.getParent() != null) {
            throw new IllegalArgumentException("Illegal state for add" + state.getId());
        }
        super.addInstanceToModelCore(state);
        if (!state.getStereoType().getStereoTypedElements().contains(state)) {
            super.setStereoType(state, state.getStereoType());
        }
        stateMachine.addState(state);
        state.setParent(stateMachine);
        if (!$assertionsDisabled && !stateMachine.getAllStates().contains(state)) {
            throw new AssertionError();
        }
    }

    public void addFinalState(TStateMachine stateMachine, TFinalState state) {
        if (!$assertionsDisabled && stateMachine == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (state.getParent() != null) {
            throw new IllegalArgumentException("Illegal state for add" + state.getId());
        }
        super.addInstanceToModelCore(state);
        if (!state.getStereoType().getStereoTypedElements().contains(state)) {
            super.setStereoType(state, state.getStereoType());
        }
        stateMachine.addFinalState(state);
        state.setParent(stateMachine);
        if (!$assertionsDisabled && !stateMachine.getAllStates().contains(state)) {
            throw new AssertionError();
        }
    }

    public void setInitialState(TStateMachine stateMachine, TInitialState state) {
        if (!$assertionsDisabled && stateMachine == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (state.getParent() != null) {
            throw new IllegalArgumentException("Illegal state for add" + state.getId());
        }
        if (stateMachine.getInitialState() != null) {
            throw new IllegalStateException("StateMachine already has initial state:" + stateMachine);
        }
        super.addInstanceToModelCore(state);
        if (!state.getStereoType().getStereoTypedElements().contains(state)) {
            super.setStereoType(state, state.getStereoType());
        }
        stateMachine.setInitialState(state);
        state.setParent(stateMachine);
        if (!$assertionsDisabled && !stateMachine.getAllStates().contains(state)) {
            throw new AssertionError();
        }
    }

    public void reconnectTransitionSource(TTransition transition, TState sourceState) {
        TState oldSource = transition.getSourceState();
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sourceState == null) {
            throw new AssertionError();
        }
        if (oldSource == null) {
            throw new IllegalArgumentException("Illegal transition" + transition.getId());
        }
        transition.setSourceState(sourceState);
        oldSource.removeSourceTransition(transition);
        sourceState.addSourceTransition(transition);
        if (!$assertionsDisabled && transition.getSourceState() != sourceState) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && oldSource.getSourceTransitions().contains(transition)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !sourceState.getSourceTransitions().contains(transition)) {
            throw new AssertionError();
        }
    }

    public void reconnectTransitionTarget(TTransition transition, TState targetState) {
        TState oldTarget = transition.getTargetState();
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && targetState == null) {
            throw new AssertionError();
        }
        if (oldTarget == null) {
            throw new IllegalArgumentException("Illegal transition" + transition.getId());
        }
        transition.setTargetState(targetState);
        oldTarget.removeTargetTransition(transition);
        targetState.addTargetTransition(transition);
        if (!$assertionsDisabled && transition.getTargetState() != targetState) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && oldTarget.getTargetTransitions().contains(transition)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !targetState.getTargetTransitions().contains(transition)) {
            throw new AssertionError();
        }
    }

    public void connectTransition(TStateMachine stateMachine, TTransition transition, TState source, TState target) {
        if (transition.getParent() != null) {
            throw new IllegalArgumentException("Illegal transition for add" + transition.getId());
        }
        super.addInstanceToModelCore(transition);
        if (!transition.getStereoType().getStereoTypedElements().contains(transition)) {
            super.setStereoType(transition, transition.getStereoType());
        }
        stateMachine.addTransition(transition);
        transition.setParent(stateMachine);
        transition.setSourceState(source);
        transition.setTargetState(target);
        source.addSourceTransition(transition);
        target.addTargetTransition(transition);
    }

    public void setTransitionSource(TTransition transition, TState source) {
        transition.setSourceState(source);
        source.addSourceTransition(transition);
    }

    public void setTransitionTarget(TTransition transition, TState target) {
        transition.setTargetState(target);
        target.addTargetTransition(transition);
    }

    public void addTransition(TStateMachine stateMachine, TTransition transition) {
        if (transition.getParent() != null) {
            throw new IllegalArgumentException("Illegal transition for add" + transition.getId());
        }
        super.addInstanceToModelCore(transition);
        if (!transition.getStereoType().getStereoTypedElements().contains(transition)) {
            super.setStereoType(transition, transition.getStereoType());
        }
        stateMachine.addTransition(transition);
        transition.setParent(stateMachine);
    }

    public void setGuardCondition(TTransition transition, TGuardCondition guard) {
        if (!guard.isNull()) {
            super.addInstanceToModelCore(guard);
            if (!guard.getStereoType().getStereoTypedElements().contains(guard)) {
                super.setStereoType(guard, guard.getStereoType());
            }
        }
        transition.setGuardCondition(guard);
        guard.setParent(transition);
    }

    public void setTransitionLabel(TTransition transition, TTransitionLabel label) {
        if (!label.isNull() && label.getTransition() != null && !label.isRemoved()) {
            throw new IllegalArgumentException("Illegal label for add" + label.getId());
        }
        if (!label.isNull()) {
            if (label.isRemoved()) {
                label.comeBack();
            } else {
                super.addInstanceToModelCore(label);
                if (!label.getStereoType().getStereoTypedElements().contains(label)) {
                    super.setStereoType(label, label.getStereoType());
                }
            }
        }
        if (transition.getLabel() != null && !transition.getLabel().isNull()) {
            transition.getLabel().remove();
        }
        transition.setLabel(label);
        label.setTransition(transition);
    }

    public void setDecisionLabel(TDecision decision, TDecisionLabel label) {
        if (label.getParent() != null) {
            throw new IllegalArgumentException("Illegal label for add" + label.getId());
        }
        super.addInstanceToModelCore(label);
        if (!label.getStereoType().getStereoTypedElements().contains(label)) {
            super.setStereoType(label, label.getStereoType());
        }
        decision.setDecisionLabel(label);
        label.setParent(decision);
    }
}

