/*
 * Decompiled with CFR 0.152.
 */
package trier.model.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectInputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectOutputStream;
import trier.model.state.TFinalState;
import trier.model.state.TInitialState;
import trier.model.state.TState;
import trier.model.state.TStateMachine;
import trier.model.state.TTransition;

public final class TStateMachineImpl
implements TStateMachine {
    private TInitialState initialState = null;
    private List states = new ArrayList();
    private List terminalStates = new ArrayList();
    private List transitions = new ArrayList();
    private String id;
    private static transient int count;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.state.TStateMachineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        count = 0;
    }

    public List getAllStates() {
        ArrayList<TInitialState> allStates = new ArrayList<TInitialState>();
        if (this.initialState != null) {
            allStates.add(this.initialState);
        }
        allStates.addAll(this.states);
        allStates.addAll(this.terminalStates);
        return allStates;
    }

    public List getStates() {
        return new ArrayList(this.states);
    }

    public void addState(TState state) {
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.states.contains(state)) {
            throw new AssertionError();
        }
        this.states.add(state);
    }

    public void removeState(TState state) {
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.states.contains(state)) {
            throw new AssertionError();
        }
        this.states.remove(state);
    }

    public TInitialState getInitialState() {
        return this.initialState;
    }

    public void setInitialState(TInitialState initialState) {
        if (!$assertionsDisabled && this.initialState != null && initialState != null) {
            throw new AssertionError();
        }
        this.initialState = initialState;
    }

    public List getFinalStates() {
        return new ArrayList(this.terminalStates);
    }

    public void addFinalState(TFinalState terminalState) {
        if (!$assertionsDisabled && terminalState == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.terminalStates.contains(terminalState)) {
            throw new AssertionError();
        }
        this.terminalStates.add(terminalState);
    }

    public void removeFinalState(TFinalState terminalState) {
        if (!$assertionsDisabled && terminalState == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.terminalStates.contains(terminalState)) {
            throw new AssertionError();
        }
        this.terminalStates.remove(terminalState);
    }

    public void addTransition(TTransition transition) {
        this.transitions.add(transition);
    }

    public List getAllTransitions() {
        return new ArrayList(this.transitions);
    }

    public void removeTransition(TTransition transition) {
        this.transitions.remove(transition);
    }

    public String getTagName() {
        return "StateElementImpl";
    }

    public String getId() {
        if (this.id == null) {
            this.id = "StateElementImpl_" + count + System.getProperty("user.name") + System.currentTimeMillis();
            ++count;
        }
        return this.id;
    }

    public void readObject(XMLObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
    }

    public void writeObject(XMLObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
    }
}

