/*
 * Decompiled with CFR 0.152.
 */
package trier.referencediagram.figure;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import trier.model.object.TInstanceVariable;
import trier.referencediagram.figure.RDTableFigure;

public class RDInstanceVariableLayout
extends AbstractLayout {
    private TInstanceVariable variable = null;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return new Dimension(this.getPrefWidth(container), this.getTextHeight());
    }

    public int getPrefWidth(IFigure container) {
        while (!(container instanceof RDTableFigure)) {
            container = container.getParent();
        }
        return container.getClientArea().width;
    }

    public void layout(IFigure container) {
        Figure fig;
        List children = container.getChildren();
        int width = (this.getPrefWidth(container) - this.getTabWidth()) / 2;
        int height = this.getTextHeight();
        if (children.size() > 0) {
            fig = (Figure)children.get(0);
            this.setBoundsOfChild(container, (IFigure)fig, new Rectangle(this.getIndent(), 0, width, height));
        }
        if (children.size() > 1) {
            fig = (Figure)children.get(1);
            this.setBoundsOfChild(container, (IFigure)fig, new Rectangle(this.getIndent() + width, 0, width, height));
        }
    }

    private int getTabWidth() {
        if (this.getVariable() == null) {
            return 0;
        }
        if (this.getVariable().getOwner() == null) {
            return 25;
        }
        if (this.getVariable().getOwner().hasArray()) {
            return 25;
        }
        return 0;
    }

    private int getIndent() {
        if (this.getVariable() == null) {
            return 0;
        }
        if (this.getVariable().getOwner() == null) {
            return 0;
        }
        if (this.getVariable().getOwner().hasArray()) {
            return 25;
        }
        return 0;
    }

    private int getTextHeight() {
        return 25;
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public TInstanceVariable getVariable() {
        return this.variable;
    }

    public void setVariable(TInstanceVariable variable) {
        this.variable = variable;
    }
}

