/*
 * Decompiled with CFR 0.152.
 */
package trier.sequencediagram.figure;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import trier.TrierPlugin;
import trier.sequencediagram.QDConstants;
import trier.sequencediagram.figure.QDElementFigure;
import trier.sequencediagram.figure.QDSequenciableElementFigure;

public class QDActorFigure
extends QDSequenciableElementFigure {
    protected QDElementFigure createObjectFigure() {
        return new QDActorObjectFigure();
    }

    class QDActorObjectFigure
    extends QDElementFigure {
        private Figure titleLayer = new Figure();
        private Label titleLabel = new Label();
        public static final int xMargin = 10;
        public static final int yMargin = 75;
        private int layoutCurrentHeight = 0;

        public QDActorObjectFigure() {
            this.initialize();
            this.initializeComponents();
        }

        protected void initialize() {
            this.setLayoutManager((LayoutManager)new XYLayout());
            this.setBorder(null);
        }

        protected void initializeComponents() {
            DelegatingLayout titleLayout = new DelegatingLayout();
            this.titleLayer.setLayoutManager((LayoutManager)titleLayout);
            this.titleLayer.setForegroundColor(QDConstants.DEFAULT_SEQUENCE_PEN_COLOR);
            this.add((IFigure)this.titleLayer);
            this.titleLayer.add((IFigure)this.titleLabel, (Object)new TitleLabelLocator());
        }

        public Label getTitleLabel() {
            return this.titleLabel;
        }

        public void setBounds(Rectangle r) {
            super.setBounds(r);
            this.titleLayer.setBounds(r);
        }

        public void add(IFigure figure, Object constraint, int index) {
            if (index == -1) {
                super.add(figure, constraint, index);
            } else if (figure == this.titleLayer) {
                super.add(figure, constraint, 0);
            } else {
                super.add(figure, constraint, index + 1);
            }
        }

        protected void paintFigure(Graphics g) {
            super.paintFigure(g);
            g.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
            g.setBackgroundColor(TrierPlugin.DEFAULT_CLASS_FILL_COLOR);
            g.setLineWidth(1);
            Rectangle r = super.getBounds();
            r = this.getBoundsForDraw(1);
            this.drawActor(g, r);
        }

        private void drawActor(Graphics g, Rectangle r) {
            g.fillRectangle(r);
            Rectangle actorR = new Rectangle(r.x, r.y, r.width, r.height - 40);
            g.drawOval(actorR.x + actorR.width / 2 - 10, actorR.y + 0, 20, 20);
            g.drawLine(actorR.x + actorR.width / 2, actorR.y + 20, actorR.x + actorR.width / 2, actorR.y + 50);
            g.drawLine(actorR.x + actorR.width / 2 - 15, actorR.y + 30, actorR.x + actorR.width / 2 + 15, actorR.y + 30);
            g.drawLine(actorR.x + actorR.width / 2, actorR.y + 50, actorR.x + actorR.width / 2 - 15, actorR.y + 70);
            g.drawLine(actorR.x + actorR.width / 2, actorR.y + 50, actorR.x + actorR.width / 2 + 15, actorR.y + 70);
            Polyline line = new Polyline();
            line.setLineStyle(3);
            line.setLocation(new Point(r.getTop().x, r.getTop().y + 95));
            line.setStart(new Point(r.getTop().x, r.getTop().y + 95));
            line.setEnd(r.getBottom());
            line.paint(g);
        }

        private int layoutGetWidth() {
            Rectangle r = QDActorFigure.this.getBounds();
            return r.width;
        }

        private int layoutGetHeight() {
            Rectangle r = QDActorFigure.this.getBounds();
            return r.height;
        }

        private Point layoutGetLocation() {
            Rectangle r = QDActorFigure.this.getBounds();
            int x = r.x + 10;
            int y = r.y + this.layoutCurrentHeight;
            return new Point(x, y);
        }

        private Point layoutGetLocationNoMargin() {
            Rectangle r = QDActorFigure.this.getBounds();
            int x = r.x;
            int y = r.y + this.layoutCurrentHeight;
            return new Point(x, y);
        }

        class TitleLabelLocator
        implements Locator {
            TitleLabelLocator() {
            }

            public void relocate(IFigure target) {
                QDActorObjectFigure.this.layoutCurrentHeight = 75;
                int width = QDActorObjectFigure.this.layoutGetWidth() - 20;
                int height = target.getPreferredSize().height;
                target.setBounds(new Rectangle(QDActorObjectFigure.this.layoutGetLocation(), new Dimension(width, height)));
                QDActorObjectFigure qDActorObjectFigure = QDActorObjectFigure.this;
                qDActorObjectFigure.layoutCurrentHeight = qDActorObjectFigure.layoutCurrentHeight + height;
            }
        }
    }
}

